/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal4j;

import com.microsoft.aad.adal4j.StringHelper;
import com.nimbusds.jwt.ReadOnlyJWTClaimsSet;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class UserInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    String uniqueId;
    String displayableId;
    String givenName;
    String familyName;
    String identityProvider;
    String passwordChangeUrl;
    Date passwordExpiresOn;

    private UserInfo() {
    }

    public String getDisplayableId() {
        return this.displayableId;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public String getGivenName() {
        return this.givenName;
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public String getIdentityProvider() {
        return this.identityProvider;
    }

    public String getPasswordChangeUrl() {
        return this.passwordChangeUrl;
    }

    public Date getPasswordExpiresOn() {
        return this.passwordExpiresOn;
    }

    static UserInfo createFromIdTokenClaims(ReadOnlyJWTClaimsSet claims) throws ParseException {
        int claimExpiry;
        if (claims == null || claims.getAllClaims().size() == 0) {
            return null;
        }
        String uniqueId = null;
        String displayableId = null;
        if (!StringHelper.isBlank(claims.getStringClaim("oid"))) {
            uniqueId = claims.getStringClaim("oid");
        } else if (!StringHelper.isBlank(claims.getStringClaim("sub"))) {
            uniqueId = claims.getStringClaim("sub");
        }
        if (!StringHelper.isBlank(claims.getStringClaim("upn"))) {
            displayableId = claims.getStringClaim("upn");
        } else if (!StringHelper.isBlank(claims.getStringClaim("email"))) {
            displayableId = claims.getStringClaim("email");
        }
        UserInfo userInfo = new UserInfo();
        userInfo.uniqueId = uniqueId;
        userInfo.displayableId = displayableId;
        userInfo.familyName = claims.getStringClaim("family_name");
        userInfo.givenName = claims.getStringClaim("given_name");
        userInfo.identityProvider = claims.getStringClaim("idp");
        if (!StringHelper.isBlank(claims.getStringClaim("pwd_url"))) {
            userInfo.passwordChangeUrl = claims.getStringClaim("pwd_url");
        }
        if (claims.getClaim("pwd_exp") != null && (claimExpiry = Integer.valueOf((String)claims.getClaim("pwd_exp")).intValue()) > 0) {
            GregorianCalendar expires = new GregorianCalendar();
            ((Calendar)expires).add(13, claimExpiry);
            userInfo.passwordExpiresOn = expires.getTime();
        }
        return userInfo;
    }
}

