/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal4j;

import com.microsoft.aad.adal4j.LogHelper;
import com.microsoft.aad.adal4j.StringHelper;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.util.Map;
import org.slf4j.Logger;

class HttpHelper {
    HttpHelper() {
    }

    static String executeHttpGet(Logger log, String url) throws Exception {
        return HttpHelper.executeHttpGet(log, url, null, null);
    }

    static String executeHttpGet(Logger log, String url, Proxy proxy) throws Exception {
        return HttpHelper.executeHttpGet(log, url, null, proxy);
    }

    static String executeHttpGet(Logger log, String url, Map<String, String> headers) throws Exception {
        HttpURLConnection conn = HttpHelper.openConnection(url);
        return HttpHelper.executeGetRequest(log, headers, conn);
    }

    static String executeHttpGet(Logger log, String url, Map<String, String> headers, Proxy proxy) throws Exception {
        HttpURLConnection conn = proxy == null ? HttpHelper.openConnection(url) : HttpHelper.openConnection(url, proxy);
        return HttpHelper.executeGetRequest(log, headers, conn);
    }

    static String executeHttpPost(Logger log, String url, String postData) throws Exception {
        return HttpHelper.executeHttpPost(log, url, postData, null);
    }

    static String executeHttpPost(Logger log, String url, String postData, Map<String, String> headers) throws Exception {
        HttpURLConnection conn = HttpHelper.openConnection(url);
        return HttpHelper.executePostRequest(log, postData, headers, conn);
    }

    static String executeHttpPost(Logger log, String url, String postData, Map<String, String> headers, Proxy proxy) throws Exception {
        HttpURLConnection conn = proxy == null ? HttpHelper.openConnection(url) : HttpHelper.openConnection(url, proxy);
        return HttpHelper.executePostRequest(log, postData, headers, conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String readResponseFromConnection(HttpURLConnection conn) throws IOException {
        InputStreamReader inReader = new InputStreamReader(conn.getInputStream());
        BufferedReader reader = new BufferedReader(inReader);
        char[] buffer = new char[256];
        StringBuilder out = new StringBuilder();
        try {
            if (conn.getResponseCode() != 200) {
                throw new IOException("Failed: HTTP error code " + conn.getResponseCode());
            }
            int rsz = -1;
            while ((rsz = reader.read(buffer, 0, buffer.length)) > -1) {
                out.append(buffer, 0, rsz);
            }
        }
        finally {
            reader.close();
        }
        return out.toString();
    }

    static HttpURLConnection openConnection(URL finalURL, Proxy proxy) throws IOException {
        return (HttpURLConnection)finalURL.openConnection(proxy);
    }

    static HttpURLConnection openConnection(URL finalURL) throws IOException {
        return (HttpURLConnection)finalURL.openConnection();
    }

    static HttpURLConnection openConnection(String url, Proxy proxy) throws IOException {
        return HttpHelper.openConnection(new URL(url), proxy);
    }

    static HttpURLConnection openConnection(String url) throws IOException {
        return HttpHelper.openConnection(new URL(url));
    }

    static HttpURLConnection configureAdditionalHeaders(HttpURLConnection conn, Map<String, String> headers) throws MalformedURLException, IOException {
        if (headers != null) {
            for (String key : headers.keySet()) {
                conn.setRequestProperty(key, headers.get(key));
            }
        }
        return conn;
    }

    static void verifyReturnedCorrelationId(Logger log, HttpURLConnection conn, String sentCorrelationId) {
        if (StringHelper.isBlank(conn.getHeaderField("client-request-id")) || !conn.getHeaderField("client-request-id").equals(sentCorrelationId)) {
            log.info(LogHelper.createMessage(String.format("Sent (%s) Correlation Id is not same as received (%s).", sentCorrelationId, conn.getHeaderField("client-request-id")), sentCorrelationId));
        }
    }

    private static String executeGetRequest(Logger log, Map<String, String> headers, HttpURLConnection conn) throws IOException {
        HttpHelper.configureAdditionalHeaders(conn, headers);
        return HttpHelper.getResponse(log, headers, conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String executePostRequest(Logger log, String postData, Map<String, String> headers, HttpURLConnection conn) throws IOException {
        HttpHelper.configureAdditionalHeaders(conn, headers);
        conn.setRequestMethod("POST");
        conn.setDoOutput(true);
        try (DataOutputStream wr = null;){
            wr = new DataOutputStream(conn.getOutputStream());
            wr.writeBytes(postData);
            wr.flush();
            String string = HttpHelper.getResponse(log, headers, conn);
            return string;
        }
    }

    private static String getResponse(Logger log, Map<String, String> headers, HttpURLConnection conn) throws IOException {
        String response = HttpHelper.readResponseFromConnection(conn);
        if (headers != null) {
            HttpHelper.verifyReturnedCorrelationId(log, conn, headers.get("client-request-id"));
        }
        return response;
    }
}

