/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal4j;

import com.microsoft.aad.adal4j.HttpHelper;
import com.microsoft.aad.adal4j.WSTrustResponse;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WSTrustRequest {
    private static final Logger log = LoggerFactory.getLogger(WSTrustRequest.class);
    private static final int MAX_EXPECTED_MESSAGE_SIZE = 1024;
    private static final String WSTRUST_ENVELOPE_TEMPLATE = "<s:Envelope xmlns:s='http://www.w3.org/2003/05/soap-envelope' xmlns:a='http://www.w3.org/2005/08/addressing' xmlns:u='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd'><s:Header><a:Action s:mustUnderstand='1'>http://docs.oasis-open.org/ws-sx/ws-trust/200512/RST/Issue</a:Action><a:messageID>urn:uuid:%s</a:messageID><a:ReplyTo><a:Address>http://www.w3.org/2005/08/addressing/anonymous</a:Address></a:ReplyTo><a:To s:mustUnderstand='1'>%s</a:To>%s</s:Header><s:Body><trust:RequestSecurityToken xmlns:trust='http://docs.oasis-open.org/ws-sx/ws-trust/200512'><wsp:AppliesTo xmlns:wsp='http://schemas.xmlsoap.org/ws/2004/09/policy'><a:EndpointReference><a:Address>%s</a:Address></a:EndpointReference></wsp:AppliesTo><trust:KeyType>http://docs.oasis-open.org/ws-sx/ws-trust/200512/Bearer</trust:KeyType><trust:RequestType>http://docs.oasis-open.org/ws-sx/ws-trust/200512/Issue</trust:RequestType></trust:RequestSecurityToken></s:Body></s:Envelope>";
    private static final String DEFAULT_APPLIES_TO = "urn:federation:MicrosoftOnline";

    WSTrustRequest() {
    }

    static WSTrustResponse execute(String url, String username, String password) throws Exception {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/soap+xml; charset=utf-8");
        headers.put("SOAPAction", "http://docs.oasis-open.org/ws-sx/ws-trust/200512/RST/Issue");
        String body = WSTrustRequest.BuildMessage(url, username, password).toString();
        String response = HttpHelper.executeHttpPost(log, url, body, headers);
        return WSTrustResponse.parse(response);
    }

    private static StringBuilder BuildMessage(String resource, String username, String password) {
        StringBuilder securityHeaderBuilder = WSTrustRequest.BuildSecurityHeader(username, password);
        String guid = UUID.randomUUID().toString();
        StringBuilder messageBuilder = new StringBuilder(1024);
        messageBuilder.append(String.format(WSTRUST_ENVELOPE_TEMPLATE, guid, resource, securityHeaderBuilder, DEFAULT_APPLIES_TO));
        return messageBuilder;
    }

    private static StringBuilder BuildSecurityHeader(String username, String password) {
        StringBuilder securityHeaderBuilder = new StringBuilder(1024);
        StringBuilder messageCredentialsBuilder = new StringBuilder(1024);
        String guid = UUID.randomUUID().toString();
        messageCredentialsBuilder.append(String.format("<o:UsernameToken u:Id='uuid-%s'><o:Username>%s</o:Username><o:Password>%s</o:Password></o:UsernameToken>", guid, username, password));
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        Date date = new Date();
        String currentTimeString = dateFormat.format(date);
        int toAdd = 600000;
        date = new Date(date.getTime() + (long)toAdd);
        String expiryTimString = dateFormat.format(date);
        securityHeaderBuilder.append(String.format("<o:Security s:mustUnderstand='1' xmlns:o='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd'><u:Timestamp u:Id='_0'><u:Created>%s</u:Created><u:Expires>%s</u:Expires></u:Timestamp>%s</o:Security>", currentTimeString, expiryTimString, messageCredentialsBuilder));
        return securityHeaderBuilder;
    }
}

