/*
 * Decompiled with CFR 0.152.
 */
package com.martensigwart.fakeload;

import com.martensigwart.fakeload.CpuSimulator;
import com.martensigwart.fakeload.DiskInputSimulator;
import com.martensigwart.fakeload.DiskOutputSimulator;
import com.martensigwart.fakeload.FakeLoad;
import com.martensigwart.fakeload.MaximumLoadExceededException;
import com.martensigwart.fakeload.MemorySimulator;
import com.martensigwart.fakeload.SystemLoad;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LoadController
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(LoadController.class);
    private static final OperatingSystemMXBean operatingSystem = ManagementFactory.getPlatformMXBean(OperatingSystemMXBean.class);
    private static final int SLEEP_PERIOD = 2000;
    private static final int CPU_CONTROL_THRESHOLD = 1;
    private final SystemLoad systemLoad;
    private final List<CpuSimulator> cpuSimulators;
    private final MemorySimulator memorySimulator;
    private final DiskInputSimulator diskInputSimulator;
    private final DiskOutputSimulator diskOutputSimulator;
    private final double stepSize;
    private final Object lock;
    private double lastCpu = -2.0;
    private long oldDesiredCpu = 0L;
    private int increaseCpuIndex;
    private int decreaseCpuIndex;

    public LoadController(SystemLoad systemLoad, List<CpuSimulator> cpuSimulators, MemorySimulator memorySimulator, DiskInputSimulator diskInputSimulator, DiskOutputSimulator diskOutputSimulator) {
        this.systemLoad = systemLoad;
        this.cpuSimulators = Collections.unmodifiableList(cpuSimulators);
        this.memorySimulator = memorySimulator;
        this.diskInputSimulator = diskInputSimulator;
        this.diskOutputSimulator = diskOutputSimulator;
        int noOfCores = Runtime.getRuntime().availableProcessors();
        this.stepSize = 1.0 / (double)noOfCores;
        this.increaseCpuIndex = 0;
        this.decreaseCpuIndex = noOfCores - 1;
        this.lock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        log.debug("LoadController - Started");
        boolean running = true;
        operatingSystem.getSystemCpuLoad();
        while (running) {
            try {
                Object object = this.lock;
                synchronized (object) {
                    while (this.systemLoad.getCpu() == 0L) {
                        log.debug("LoadController - Nothing to control, waiting...");
                        this.lock.wait();
                        log.debug("LoadController - Woke Up");
                    }
                }
                Thread.sleep(2000L);
                this.controlCpuLoad();
            }
            catch (InterruptedException e) {
                log.debug("LoadController - Interrupted");
                running = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increaseSystemLoadBy(FakeLoad load) throws MaximumLoadExceededException {
        this.systemLoad.increaseBy(load);
        for (CpuSimulator cpuSim : this.cpuSimulators) {
            cpuSim.setLoad(this.systemLoad.getCpu());
        }
        Object object = this.lock;
        synchronized (object) {
            this.lock.notify();
        }
        this.memorySimulator.setLoad(this.systemLoad.getMemory());
        this.diskInputSimulator.setLoad(this.systemLoad.getDiskInput());
        this.diskOutputSimulator.setLoad(this.systemLoad.getDiskOutput());
    }

    public void decreaseSystemLoadBy(FakeLoad load) {
        this.systemLoad.decreaseBy(load);
        for (CpuSimulator cpuSim : this.cpuSimulators) {
            cpuSim.setLoad(this.systemLoad.getCpu());
        }
        this.memorySimulator.setLoad(this.systemLoad.getMemory());
        this.diskInputSimulator.setLoad(this.systemLoad.getDiskInput());
        this.diskOutputSimulator.setLoad(this.systemLoad.getDiskOutput());
    }

    private void controlCpuLoad() {
        long desiredCpu = this.systemLoad.getCpu();
        if (desiredCpu != this.oldDesiredCpu) {
            log.trace("Last desired load: {}, new desired load: {} --> Not adjusting CPU load", (Object)this.oldDesiredCpu, (Object)desiredCpu);
            this.oldDesiredCpu = desiredCpu;
            return;
        }
        double actualCpu = operatingSystem.getSystemCpuLoad() * 100.0;
        log.trace("Desired CPU: {}, Actual CPU: {}, Last CPU: {}", new Object[]{desiredCpu, actualCpu, this.lastCpu});
        double difference = actualCpu - (double)desiredCpu;
        if (Math.abs(difference) > 1.0 && Math.abs(this.lastCpu - actualCpu) <= 1.0) {
            int noOfSteps = (int)(Math.abs(difference) / this.stepSize);
            log.trace("Number of adjustment steps: {}", (Object)noOfSteps);
            if (difference < 0.0) {
                log.trace("Increasing CPU load, difference {}", (Object)difference);
                this.increaseCpuSimulatorLoads(1, noOfSteps);
            } else {
                log.trace("Decreasing CPU load, difference {}", (Object)difference);
                this.decreaseCpuSimulatorLoads(1, noOfSteps);
            }
        }
        this.lastCpu = actualCpu;
    }

    private void increaseCpuSimulatorLoads(int delta, int noOfSteps) {
        for (int i = 0; i < noOfSteps; ++i) {
            CpuSimulator cpuSimulator = this.cpuSimulators.get(this.increaseCpuIndex);
            this.decreaseCpuIndex = this.increaseCpuIndex;
            this.increaseCpuIndex = (this.increaseCpuIndex + 1) % this.cpuSimulators.size();
            if (cpuSimulator.isMaximumLoad()) continue;
            cpuSimulator.increaseLoad(delta);
        }
    }

    private void decreaseCpuSimulatorLoads(int delta, int noOfSteps) {
        for (int i = 0; i < noOfSteps; ++i) {
            CpuSimulator cpuSimulator = this.cpuSimulators.get(this.decreaseCpuIndex);
            this.increaseCpuIndex = this.decreaseCpuIndex;
            this.decreaseCpuIndex = (this.cpuSimulators.size() - 1 + this.decreaseCpuIndex) % this.cpuSimulators.size();
            if (cpuSimulator.isZeroLoad()) continue;
            cpuSimulator.decreaseLoad(delta);
        }
    }

    public List<CpuSimulator> getCpuSimulators() {
        return this.cpuSimulators;
    }

    public MemorySimulator getMemorySimulator() {
        return this.memorySimulator;
    }

    public DiskInputSimulator getDiskInputSimulator() {
        return this.diskInputSimulator;
    }

    public DiskOutputSimulator getDiskOutputSimulator() {
        return this.diskOutputSimulator;
    }
}

