/*
 * Decompiled with CFR 0.152.
 */
package com.martensigwart.fakeload;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

final class IteratorOfIterators<T>
implements Iterator<T> {
    private final List<Iterator<T>> iterators;
    private int activeIterator = 0;

    IteratorOfIterators(List<Iterator<T>> iterators) {
        this.iterators = iterators;
    }

    @SafeVarargs
    IteratorOfIterators(Iterator<T> ... iterators) {
        this.iterators = Arrays.asList(iterators);
    }

    @Override
    public boolean hasNext() {
        if (this.activeIterator >= this.iterators.size()) {
            return false;
        }
        if (this.iterators.get(this.activeIterator).hasNext()) {
            return true;
        }
        ++this.activeIterator;
        return this.hasNext();
    }

    @Override
    public T next() {
        if (this.hasNext()) {
            return this.iterators.get(this.activeIterator).next();
        }
        throw new NoSuchElementException();
    }
}

