/*
 * Decompiled with CFR 0.152.
 */
package com.martensigwart.fakeload;

import com.martensigwart.fakeload.CpuSimulator;
import com.martensigwart.fakeload.DiskInputSimulator;
import com.martensigwart.fakeload.DiskOutputSimulator;
import com.martensigwart.fakeload.FakeLoad;
import com.martensigwart.fakeload.LoadController;
import com.martensigwart.fakeload.MaximumLoadExceededException;
import com.martensigwart.fakeload.MemorySimulator;
import com.martensigwart.fakeload.SimulationInfrastructure;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class DefaultSimulationInfrastructure
implements SimulationInfrastructure {
    private static final Logger log = LoggerFactory.getLogger(SimulationInfrastructure.class);
    private final ExecutorService executorService;
    private final LoadController controller;
    @GuardedBy(value="this")
    private boolean started;

    public DefaultSimulationInfrastructure(ExecutorService executorService, LoadController controller) {
        this.executorService = executorService;
        this.controller = controller;
        this.started = false;
        Runtime.getRuntime().addShutdownHook(new Thread(this::shutdown));
    }

    @Override
    public void increaseSystemLoadBy(FakeLoad load) throws MaximumLoadExceededException {
        this.start();
        this.controller.increaseSystemLoadBy(load);
    }

    @Override
    public void decreaseSystemLoadBy(FakeLoad load) {
        this.controller.decreaseSystemLoadBy(load);
    }

    private synchronized void start() {
        if (!this.started) {
            log.debug("Starting infrastructure...");
            this.startLoadController();
            this.startCpuSimulators();
            this.startMemorySimulator();
            this.startDiskInputSimulator();
            this.startDiskOutputSimulator();
            this.started = true;
            log.debug("Successfully started infrastructure");
        }
    }

    private void startLoadController() {
        CompletableFuture.runAsync(this.controller, this.executorService);
        log.debug("Started Simulation Control");
    }

    private void startCpuSimulators() {
        List<CpuSimulator> cpuSimulators = this.controller.getCpuSimulators();
        for (Runnable runnable : cpuSimulators) {
            CompletableFuture<Void> future = CompletableFuture.runAsync(runnable, this.executorService);
            future.exceptionally(e -> {
                log.error("Cpu Simulator died: {}", (Object)e.getMessage());
                e.printStackTrace();
                return null;
            });
        }
        log.debug("Started {} CPU Simulators", (Object)cpuSimulators.size());
    }

    private void startMemorySimulator() {
        MemorySimulator memorySimulator = this.controller.getMemorySimulator();
        if (memorySimulator == null) {
            return;
        }
        memorySimulator.setLoad(0L);
        CompletableFuture<Void> future = CompletableFuture.runAsync(memorySimulator, this.executorService);
        future.exceptionally(e -> {
            log.warn("Memory Simulator died: {}, starting new one...", (Object)e.getMessage());
            this.startMemorySimulator();
            return null;
        });
        log.debug("Started Memory Simulator");
    }

    private void startDiskInputSimulator() {
        DiskInputSimulator diskInputSimulator = this.controller.getDiskInputSimulator();
        if (diskInputSimulator == null) {
            return;
        }
        CompletableFuture<Void> future = CompletableFuture.runAsync(diskInputSimulator, this.executorService);
        future.exceptionally(e -> {
            log.error("Disk Input Simulator died: {}", (Object)e.getMessage());
            e.printStackTrace();
            return null;
        });
        log.debug("Started DiskInput Simulator");
    }

    private void startDiskOutputSimulator() {
        DiskOutputSimulator diskOutputSimulator = this.controller.getDiskOutputSimulator();
        if (diskOutputSimulator == null) {
            return;
        }
        CompletableFuture<Void> future = CompletableFuture.runAsync(diskOutputSimulator, this.executorService);
        future.exceptionally(e -> {
            log.error("Disk Output Simulator died: {}", (Object)e.getMessage());
            e.printStackTrace();
            return null;
        });
        log.debug("Started Disk Output Simulator");
    }

    @Override
    public void shutdown() {
        this.executorService.shutdownNow();
        try {
            if (!this.executorService.awaitTermination(50L, TimeUnit.MILLISECONDS)) {
                log.warn("Still waiting for termination...");
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        log.debug("ExecutorService shutdown");
    }
}

