/*
 * Decompiled with CFR 0.152.
 */
package com.martensigwart.fakeload;

import com.martensigwart.fakeload.AbstractFakeLoad;
import com.martensigwart.fakeload.FakeLoad;
import com.martensigwart.fakeload.IteratorOfIterators;
import com.martensigwart.fakeload.MemoryUnit;
import com.martensigwart.fakeload.Preconditions;
import com.martensigwart.fakeload.SimpleFakeLoad;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

final class CompositeFakeLoad
extends AbstractFakeLoad {
    private final SimpleFakeLoad ownLoad;
    private final List<FakeLoad> innerLoads;

    CompositeFakeLoad(SimpleFakeLoad ownLoad, List<FakeLoad> innerLoads, int repetitions) {
        super(repetitions);
        this.ownLoad = (SimpleFakeLoad)Preconditions.checkNotNull(ownLoad).repeat(1);
        this.innerLoads = Collections.unmodifiableList(innerLoads);
    }

    CompositeFakeLoad(List<FakeLoad> innerLoads, int repetitions) {
        this(new SimpleFakeLoad(), innerLoads, repetitions);
    }

    CompositeFakeLoad(List<FakeLoad> innerLoads) {
        this(innerLoads, 1);
    }

    CompositeFakeLoad() {
        this(new ArrayList<FakeLoad>());
    }

    @Override
    public FakeLoad lasting(long duration, TimeUnit unit) {
        SimpleFakeLoad newOwnLoad = (SimpleFakeLoad)this.ownLoad.lasting(duration, unit);
        return new CompositeFakeLoad(newOwnLoad, this.innerLoads, this.getRepetitions());
    }

    @Override
    public FakeLoad repeat(int noOfRepetitions) {
        return new CompositeFakeLoad(this.ownLoad, this.innerLoads, noOfRepetitions);
    }

    @Override
    public FakeLoad withCpu(int cpuLoad) {
        SimpleFakeLoad newOwnLoad = (SimpleFakeLoad)this.ownLoad.withCpu(cpuLoad);
        return new CompositeFakeLoad(newOwnLoad, this.innerLoads, this.getRepetitions());
    }

    @Override
    public FakeLoad withMemory(long amount, MemoryUnit unit) {
        SimpleFakeLoad newOwnLoad = (SimpleFakeLoad)this.ownLoad.withMemory(amount, unit);
        return new CompositeFakeLoad(newOwnLoad, this.innerLoads, this.getRepetitions());
    }

    @Override
    public FakeLoad withDiskInput(long load, MemoryUnit unit) {
        SimpleFakeLoad newOwnLoad = (SimpleFakeLoad)this.ownLoad.withDiskInput(load, unit);
        return new CompositeFakeLoad(newOwnLoad, this.innerLoads, this.getRepetitions());
    }

    @Override
    public FakeLoad withDiskOutput(long load, MemoryUnit unit) {
        SimpleFakeLoad newOwnLoad = (SimpleFakeLoad)this.ownLoad.withDiskOutput(load, unit);
        return new CompositeFakeLoad(newOwnLoad, this.innerLoads, this.getRepetitions());
    }

    @Override
    public FakeLoad addLoad(FakeLoad load) {
        ArrayList<FakeLoad> newLoads;
        Preconditions.checkNotNull(load);
        if (this.innerLoads.isEmpty()) {
            newLoads = new ArrayList<FakeLoad>();
            newLoads.add(load);
        } else {
            newLoads = new ArrayList();
            newLoads.addAll(this.innerLoads);
            newLoads.add(load);
        }
        return new CompositeFakeLoad(this.ownLoad, newLoads, this.getRepetitions());
    }

    @Override
    public FakeLoad addLoads(Collection<FakeLoad> loads) {
        ArrayList<FakeLoad> newLoads;
        Preconditions.checkNotNull(loads);
        if (this.innerLoads.isEmpty()) {
            newLoads = new ArrayList<FakeLoad>(loads);
        } else {
            newLoads = new ArrayList<FakeLoad>(this.innerLoads);
            newLoads.addAll(loads);
        }
        return new CompositeFakeLoad(this.ownLoad, newLoads, this.getRepetitions());
    }

    @Override
    public boolean contains(FakeLoad load) {
        if (this.equals(load)) {
            return true;
        }
        for (FakeLoad l : this.getInnerLoads()) {
            if (!l.contains(load)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<FakeLoad> getInnerLoads() {
        return this.innerLoads;
    }

    @Override
    public int getCpu() {
        return this.ownLoad.getCpu();
    }

    @Override
    public long getMemory() {
        return this.ownLoad.getMemory();
    }

    @Override
    public long getDiskInput() {
        return this.ownLoad.getDiskInput();
    }

    @Override
    public long getDiskOutput() {
        return this.ownLoad.getDiskOutput();
    }

    @Override
    public long getDuration() {
        return this.ownLoad.getDuration();
    }

    @Override
    public TimeUnit getTimeUnit() {
        return this.ownLoad.getTimeUnit();
    }

    @Override
    @Nonnull
    public Iterator<FakeLoad> iterator() {
        Iterator<FakeLoad> iterator = this.ownLoad.iterator();
        for (int i = 0; i < this.getRepetitions(); ++i) {
            if (i != 0) {
                iterator = new IteratorOfIterators<FakeLoad>(iterator, this.ownLoad.iterator());
            }
            for (FakeLoad load : this.innerLoads) {
                iterator = new IteratorOfIterators<FakeLoad>(iterator, load.iterator());
            }
        }
        return iterator;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompositeFakeLoad fakeload = (CompositeFakeLoad)o;
        return Objects.equals(this.ownLoad, fakeload.ownLoad) && Objects.equals(this.innerLoads, fakeload.innerLoads);
    }

    public int hashCode() {
        return Objects.hash(this.ownLoad, this.innerLoads);
    }

    public String toString() {
        return "CompositeFakeLoad{ownLoad=" + this.ownLoad + ", innerLoads=" + this.innerLoads + '}';
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required");
    }

    private Object writeReplace() {
        return new AbstractFakeLoad.SerializationProxy(this);
    }
}

