/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.contentpump.test;

import com.marklogic.contentpump.examples.SimpleSequenceFileKey;
import com.marklogic.contentpump.examples.SimpleSequenceFileValue;
import com.marklogic.mapreduce.DocumentURI;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileReader;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.GzipCodec;

public class SimpleSequenceFileCompressCreator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        System.out.println("Sequence File Creator");
        String uri = args[0];
        String filePath = args[1];
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.get((URI)URI.create(uri), (Configuration)conf);
        Path path = new Path(uri);
        SequenceFile.Writer writer = null;
        SimpleSequenceFileKey key = new SimpleSequenceFileKey();
        String line = null;
        try (BufferedReader buffer = new BufferedReader(new FileReader(filePath));){
            SimpleSequenceFileValue<Text> value = new SimpleSequenceFileValue<Text>();
            writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)conf, (Path)path, key.getClass(), value.getClass(), (SequenceFile.CompressionType)SequenceFile.CompressionType.RECORD, (CompressionCodec)new GzipCodec());
            while ((line = buffer.readLine()) != null) {
                key.setDocumentURI(new DocumentURI(line));
                line = buffer.readLine();
                if (line == null) {
                    break;
                }
                value.setValue(new Text(line));
                writer.append((Writable)key, value);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeStream(writer);
            throw throwable;
        }
        IOUtils.closeStream((Closeable)writer);
    }
}

