/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.contentpump;

import com.marklogic.contentpump.TransformWriter;
import com.marklogic.mapreduce.ContentOutputFormat;
import com.marklogic.mapreduce.DocumentURI;
import com.marklogic.mapreduce.LinkedMapWritable;
import com.marklogic.mapreduce.utilities.InternalUtilities;
import com.marklogic.xcc.AdhocQuery;
import com.marklogic.xcc.ContentSource;
import com.marklogic.xcc.Request;
import com.marklogic.xcc.RequestOptions;
import com.marklogic.xcc.ResultSequence;
import com.marklogic.xcc.Session;
import com.marklogic.xcc.exceptions.ServerConnectionException;
import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DefaultStringifier;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class TransformOutputFormat<VALUEOUT>
extends ContentOutputFormat<VALUEOUT> {
    static final String MIMETYPES_QUERY = "import module namespace hadoop = \"http://marklogic.com/xdmp/hadoop\" at \"/MarkLogic/hadoop.xqy\";\nlet $f :=   fn:function-lookup(xs:QName('hadoop:get-mimetypes-map'),0)\nlet $hasFunc := exists($f)return  if($hasFunc eq fn:true()) then $f()\nelse ()";
    public static LinkedMapWritable mimetypeMap = null;

    private LinkedMapWritable getMimetypesMap() throws IOException {
        if (mimetypeMap != null) {
            return mimetypeMap;
        }
        String mtmap = this.conf.get("mapreduce.marklogic.mimetypes");
        if (mtmap != null) {
            mimetypeMap = (LinkedMapWritable)DefaultStringifier.load((Configuration)this.conf, (String)"mapreduce.marklogic.mimetypes", LinkedMapWritable.class);
            return mimetypeMap;
        }
        String[] hosts = this.conf.getStrings("mapreduce.marklogic.output.host");
        Session session = null;
        ResultSequence result = null;
        for (int i = 0; i < hosts.length; ++i) {
            try {
                String host = hosts[i];
                ContentSource cs = InternalUtilities.getOutputContentSource((Configuration)this.conf, (String)host);
                session = cs.newSession();
                AdhocQuery query = session.newAdhocQuery(MIMETYPES_QUERY);
                RequestOptions options = new RequestOptions();
                options.setDefaultXQueryVersion("1.0-ml");
                query.setOptions(options);
                result = session.submitRequest((Request)query);
                if (!result.hasNext()) {
                    throw new IOException("Server-side transform requires MarkLogic 7 or later");
                }
                mimetypeMap = new LinkedMapWritable();
                while (result.hasNext()) {
                    String suffs = result.next().asString();
                    Text format = new Text(result.next().asString());
                    for (String s : suffs.split(" ")) {
                        Text suff = new Text(s);
                        mimetypeMap.put((Writable)suff, (Writable)format);
                    }
                }
                LinkedMapWritable linkedMapWritable = mimetypeMap;
                return linkedMapWritable;
            }
            catch (Exception e) {
                if (e.getCause() instanceof ServerConnectionException) {
                    LOG.warn((Object)("Unable to connect to " + hosts[i] + " to query destination information"));
                    continue;
                }
                LOG.error((Object)e.getMessage(), (Throwable)e);
                throw new IOException(e);
            }
            finally {
                if (result != null) {
                    result.close();
                }
                if (session != null) {
                    session.close();
                }
            }
        }
        return null;
    }

    public RecordWriter<DocumentURI, VALUEOUT> getRecordWriter(TaskAttemptContext context) throws IOException, InterruptedException {
        Configuration conf = context.getConfiguration();
        this.fastLoad = Boolean.valueOf(conf.get("mapreduce.marklogic.output.content.fastload"));
        Map sourceMap = this.getSourceMap(this.fastLoad, context);
        this.getMimetypesMap();
        return new TransformWriter(conf, sourceMap, this.fastLoad, this.am);
    }

    public void checkOutputSpecs(Configuration conf, ContentSource cs) throws IOException {
        super.checkOutputSpecs(conf, cs);
        DefaultStringifier.store((Configuration)conf, (Object)this.getMimetypesMap(), (String)"mapreduce.marklogic.mimetypes");
    }
}

