/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.contentpump;

import com.marklogic.contentpump.AggregateXMLInputFormat;
import com.marklogic.contentpump.ArchiveInputFormat;
import com.marklogic.contentpump.BaseMapper;
import com.marklogic.contentpump.CombineDocumentInputFormat;
import com.marklogic.contentpump.Command;
import com.marklogic.contentpump.CompressedAggXMLInputFormat;
import com.marklogic.contentpump.CompressedDelimitedJSONInputFormat;
import com.marklogic.contentpump.CompressedDelimitedTextInputFormat;
import com.marklogic.contentpump.CompressedDocumentInputFormat;
import com.marklogic.contentpump.CompressedRDFInputFormat;
import com.marklogic.contentpump.ConfigConstants;
import com.marklogic.contentpump.DatabaseContentOutputFormat;
import com.marklogic.contentpump.DatabaseTransformOutputFormat;
import com.marklogic.contentpump.DelimitedJSONInputFormat;
import com.marklogic.contentpump.DelimitedTextInputFormat;
import com.marklogic.contentpump.DocumentMapper;
import com.marklogic.contentpump.RDFInputFormat;
import com.marklogic.contentpump.SequenceFileInputFormat;
import com.marklogic.contentpump.StreamingDocumentInputFormat;
import com.marklogic.contentpump.TransformOutputFormat;
import com.marklogic.mapreduce.ContentOutputFormat;
import com.marklogic.mapreduce.ContentType;
import com.marklogic.mapreduce.ForestInputFormat;
import com.marklogic.mapreduce.LinkedMapWritable;
import com.marklogic.mapreduce.utilities.InternalUtilities;
import com.marklogic.xcc.AdhocQuery;
import com.marklogic.xcc.ContentSource;
import com.marklogic.xcc.Request;
import com.marklogic.xcc.RequestOptions;
import com.marklogic.xcc.ResultSequence;
import com.marklogic.xcc.Session;
import com.marklogic.xcc.exceptions.RequestException;
import com.marklogic.xcc.exceptions.ServerConnectionException;
import com.marklogic.xcc.exceptions.XccConfigException;
import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DefaultStringifier;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;

public enum InputType implements ConfigConstants
{
    DOCUMENTS{

        @Override
        public Class<? extends FileInputFormat> getInputFormatClass(CommandLine cmdline, Configuration conf) {
            if (Command.isInputCompressed(cmdline)) {
                return CompressedDocumentInputFormat.class;
            }
            if (Command.isStreaming(cmdline, conf)) {
                return StreamingDocumentInputFormat.class;
            }
            return CombineDocumentInputFormat.class;
        }

        @Override
        public Class<? extends OutputFormat> getOutputFormatClass(CommandLine cmdline, Configuration conf) {
            if (cmdline.hasOption("transform_module")) {
                return TransformOutputFormat.class;
            }
            return ContentOutputFormat.class;
        }

        @Override
        public ContentType getContentType(CommandLine cmdline) {
            String type = cmdline.getOptionValue("document_type", ContentType.MIXED.name());
            return ContentType.forName((String)type);
        }

        @Override
        public void applyConfigOptions(Configuration conf, CommandLine cmdline) throws IOException {
        }
    }
    ,
    AGGREGATES{

        @Override
        public Class<? extends FileInputFormat> getInputFormatClass(CommandLine cmdline, Configuration conf) {
            if (Command.isInputCompressed(cmdline)) {
                return CompressedAggXMLInputFormat.class;
            }
            return AggregateXMLInputFormat.class;
        }

        @Override
        public Class<? extends OutputFormat> getOutputFormatClass(CommandLine cmdline, Configuration conf) {
            if (cmdline.hasOption("transform_module")) {
                return TransformOutputFormat.class;
            }
            return ContentOutputFormat.class;
        }

        @Override
        public ContentType getContentType(CommandLine cmdline) {
            return ContentType.XML;
        }

        @Override
        public void applyConfigOptions(Configuration conf, CommandLine cmdline) throws IOException {
        }
    }
    ,
    DELIMITED_TEXT{

        @Override
        public Class<? extends FileInputFormat> getInputFormatClass(CommandLine cmdline, Configuration conf) {
            if (Command.isInputCompressed(cmdline)) {
                return CompressedDelimitedTextInputFormat.class;
            }
            return DelimitedTextInputFormat.class;
        }

        @Override
        public Class<? extends OutputFormat> getOutputFormatClass(CommandLine cmdline, Configuration conf) {
            if (cmdline.hasOption("transform_module")) {
                return TransformOutputFormat.class;
            }
            return ContentOutputFormat.class;
        }

        @Override
        public ContentType getContentType(CommandLine cmdline) {
            String type = cmdline.getOptionValue("document_type", ContentType.XML.name());
            return ContentType.forName((String)type);
        }

        @Override
        public void applyConfigOptions(Configuration conf, CommandLine cmdline) throws IOException {
        }
    }
    ,
    ARCHIVE{

        @Override
        public Class<? extends FileInputFormat> getInputFormatClass(CommandLine cmdline, Configuration conf) {
            return ArchiveInputFormat.class;
        }

        @Override
        public Class<? extends OutputFormat> getOutputFormatClass(CommandLine cmdline, Configuration conf) {
            if (cmdline.hasOption("transform_module")) {
                return DatabaseTransformOutputFormat.class;
            }
            return DatabaseContentOutputFormat.class;
        }

        @Override
        public ContentType getContentType(CommandLine cmdline) {
            return ContentType.XML;
        }

        @Override
        public void applyConfigOptions(Configuration conf, CommandLine cmdline) throws IOException {
        }
    }
    ,
    SEQUENCEFILE{

        @Override
        public Class<? extends FileInputFormat> getInputFormatClass(CommandLine cmdline, Configuration conf) {
            return SequenceFileInputFormat.class;
        }

        @Override
        public Class<? extends OutputFormat> getOutputFormatClass(CommandLine cmdline, Configuration conf) {
            if (cmdline.hasOption("transform_module")) {
                return TransformOutputFormat.class;
            }
            return ContentOutputFormat.class;
        }

        @Override
        public ContentType getContentType(CommandLine cmdline) {
            String type = cmdline.getOptionValue("document_type", ContentType.XML.name());
            return ContentType.forName((String)type);
        }

        @Override
        public void applyConfigOptions(Configuration conf, CommandLine cmdline) throws IOException {
        }
    }
    ,
    RDF{
        private String ROLE_QUERY = "import module namespace hadoop = \"http://marklogic.com/xdmp/hadoop\" at \"/MarkLogic/hadoop.xqy\";\nlet $version := xdmp:version()\nlet $f :=   fn:function-lookup(xs:QName('hadoop:get-role-map'),0)\nlet $hasFunc := fn:exists($f)return  ($version,$hasFunc,if($hasFunc eq fn:true()) then $f()\nelse () )";

        @Override
        public Class<? extends FileInputFormat> getInputFormatClass(CommandLine cmdline, Configuration conf) {
            if (Command.isInputCompressed(cmdline)) {
                return CompressedRDFInputFormat.class;
            }
            return RDFInputFormat.class;
        }

        @Override
        public Class<? extends OutputFormat> getOutputFormatClass(CommandLine cmdline, Configuration conf) {
            if (cmdline.hasOption("transform_module")) {
                return TransformOutputFormat.class;
            }
            return ContentOutputFormat.class;
        }

        @Override
        public ContentType getContentType(CommandLine cmdline) {
            return ContentType.XML;
        }

        @Override
        public void applyConfigOptions(Configuration conf, CommandLine cmdline) throws IOException {
            Session session = null;
            ResultSequence result = null;
            String[] outputHosts = conf.getStrings("mapreduce.marklogic.output.host");
            int hostIdx = 0;
            while (hostIdx < outputHosts.length) {
                try {
                    ContentSource cs = InternalUtilities.getOutputContentSource((Configuration)conf, (String)outputHosts[hostIdx]);
                    session = cs.newSession("Security");
                    RequestOptions options = new RequestOptions();
                    options.setDefaultXQueryVersion("1.0-ml");
                    session.setDefaultRequestOptions(options);
                    AdhocQuery query = session.newAdhocQuery(this.ROLE_QUERY);
                    query.setOptions(options);
                    result = session.submitRequest((Request)query);
                    Text version = new Text(result.next().asString());
                    boolean hasFunc = Boolean.parseBoolean(result.next().asString());
                    LinkedMapWritable roleMap = new LinkedMapWritable();
                    if (hasFunc) {
                        while (result.hasNext()) {
                            Text key = new Text(result.next().asString());
                            if (!result.hasNext()) {
                                throw new IOException("Invalid role map");
                            }
                            Text value = new Text(result.next().asString());
                            roleMap.put((Writable)key, (Writable)value);
                        }
                        DefaultStringifier.store((Configuration)conf, (Object)roleMap, (String)"mapreduce.marklogic.output.rolemap");
                    }
                    DefaultStringifier.store((Configuration)conf, (Object)version, (String)"mapreduce.marklogic.serverversion");
                    if (conf.get("mapreduce.marklogic.output.content.directory") == null && conf.get("mapreduce.marklogic.output_uriprefix") == null) {
                        conf.set("mapreduce.marklogic.output_uriprefix", "/triplestore/");
                    }
                    return;
                }
                catch (ServerConnectionException e) {
                    LOG.warn((Object)("Unable to connect to " + outputHosts[hostIdx] + " to query destination information"));
                    ++hostIdx;
                }
                catch (XccConfigException e) {
                    throw new IOException(e);
                }
                catch (RequestException e) {
                    throw new IOException(e);
                }
                finally {
                    if (result != null) {
                        result.close();
                    }
                    if (session == null) continue;
                    session.close();
                }
            }
            throw new IOException("Unable to query destination information, no usable hostname found");
        }
    }
    ,
    FOREST{

        @Override
        public Class<? extends FileInputFormat> getInputFormatClass(CommandLine cmdline, Configuration conf) {
            return ForestInputFormat.class;
        }

        @Override
        public Class<? extends OutputFormat> getOutputFormatClass(CommandLine cmdline, Configuration conf) {
            if (cmdline.hasOption("transform_module")) {
                return TransformOutputFormat.class;
            }
            return ContentOutputFormat.class;
        }

        @Override
        public ContentType getContentType(CommandLine cmdline) {
            return ContentType.MIXED;
        }

        @Override
        public void applyConfigOptions(Configuration conf, CommandLine cmdline) throws IOException {
        }
    }
    ,
    DELIMITED_JSON{

        @Override
        public Class<? extends FileInputFormat> getInputFormatClass(CommandLine cmdline, Configuration conf) {
            if (Command.isInputCompressed(cmdline)) {
                return CompressedDelimitedJSONInputFormat.class;
            }
            return DelimitedJSONInputFormat.class;
        }

        @Override
        public Class<? extends OutputFormat> getOutputFormatClass(CommandLine cmdline, Configuration conf) {
            if (cmdline.hasOption("transform_module")) {
                return TransformOutputFormat.class;
            }
            return ContentOutputFormat.class;
        }

        @Override
        public ContentType getContentType(CommandLine cmdline) {
            return ContentType.JSON;
        }

        @Override
        public void applyConfigOptions(Configuration conf, CommandLine cmdline) throws IOException {
        }
    };

    public static final Log LOG;

    public static InputType forName(String type) {
        if (type.equalsIgnoreCase(DOCUMENTS.name())) {
            return DOCUMENTS;
        }
        if (type.equalsIgnoreCase(AGGREGATES.name())) {
            return AGGREGATES;
        }
        if (type.equalsIgnoreCase(DELIMITED_TEXT.name())) {
            return DELIMITED_TEXT;
        }
        if (type.equalsIgnoreCase(ARCHIVE.name())) {
            return ARCHIVE;
        }
        if (type.equalsIgnoreCase(SEQUENCEFILE.name())) {
            return SEQUENCEFILE;
        }
        if (type.equalsIgnoreCase(RDF.name())) {
            return RDF;
        }
        if (type.equalsIgnoreCase(FOREST.name())) {
            return FOREST;
        }
        if (type.equalsIgnoreCase(DELIMITED_JSON.name())) {
            return DELIMITED_JSON;
        }
        throw new IllegalArgumentException("Unknown input type: " + type);
    }

    public abstract Class<? extends FileInputFormat> getInputFormatClass(CommandLine var1, Configuration var2);

    public <K1, V1, K2, V2> Class<? extends BaseMapper<K1, V1, K2, V2>> getMapperClass(CommandLine cmdline, Configuration conf) {
        return DocumentMapper.class;
    }

    public abstract Class<? extends OutputFormat> getOutputFormatClass(CommandLine var1, Configuration var2);

    public abstract ContentType getContentType(CommandLine var1);

    public abstract void applyConfigOptions(Configuration var1, CommandLine var2) throws IOException;

    public int getMinThreads() {
        return 1;
    }

    static {
        LOG = LogFactory.getLog(InputType.class);
    }
}

