/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.contentpump;

import com.marklogic.contentpump.DelimitedJSONReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.zip.GZIPInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;

public class GzipDelimitedJSONReader
extends DelimitedJSONReader<Text> {
    public static final Log LOG = LogFactory.getLog(GzipDelimitedJSONReader.class);
    private InputStream gzipIn;

    @Override
    protected void initFileStream(InputSplit inSplit) throws IOException, InterruptedException {
        this.fileIn = this.openFile(inSplit, true);
        if (this.fileIn == null) {
            return;
        }
        this.gzipIn = new GZIPInputStream((InputStream)this.fileIn);
        this.instream = new InputStreamReader(this.gzipIn, this.encoding);
        this.reader = new LineNumberReader(this.instream);
    }

    @Override
    public float getProgress() throws IOException, InterruptedException {
        return this.hasNext ? 0.0f : 1.0f;
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.gzipIn != null) {
            this.gzipIn.close();
        }
    }
}

