/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.contentpump;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.marklogic.contentpump.ConfigConstants;
import com.marklogic.contentpump.DatabaseDocumentWithMeta;
import com.marklogic.contentpump.DocumentMetadata;
import com.marklogic.contentpump.URIMetadata;
import com.marklogic.mapreduce.ContentType;
import com.marklogic.mapreduce.ContentWriter;
import com.marklogic.mapreduce.DocumentURI;
import com.marklogic.mapreduce.MarkLogicCounter;
import com.marklogic.mapreduce.MarkLogicDocument;
import com.marklogic.mapreduce.utilities.AssignmentManager;
import com.marklogic.mapreduce.utilities.InternalUtilities;
import com.marklogic.xcc.AdhocQuery;
import com.marklogic.xcc.Content;
import com.marklogic.xcc.ContentCreateOptions;
import com.marklogic.xcc.ContentFactory;
import com.marklogic.xcc.ContentPermission;
import com.marklogic.xcc.ContentSource;
import com.marklogic.xcc.Request;
import com.marklogic.xcc.Session;
import com.marklogic.xcc.ValueFactory;
import com.marklogic.xcc.exceptions.RequestException;
import com.marklogic.xcc.types.ValueType;
import com.marklogic.xcc.types.XName;
import com.marklogic.xcc.types.XdmValue;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class DatabaseContentWriter<VALUE>
extends ContentWriter<VALUE>
implements ConfigConstants {
    public static final Log LOG = LogFactory.getLog(DatabaseContentWriter.class);
    private URIMetadata[][] metadatas;
    protected XdmValue[][] propertyUris = null;
    protected XdmValue[][] propertyXmlStrings = null;
    protected int[] propertyCounts = null;
    protected boolean isCopyProps;
    protected boolean isCopyPerms;
    public static final String XQUERY_VERSION_1_0_ML = "xquery version \"1.0-ml\";\n";

    public DatabaseContentWriter(Configuration conf, Map<String, ContentSource> hostSourceMap, boolean fastLoad) {
        this(conf, hostSourceMap, fastLoad, null);
    }

    public DatabaseContentWriter(Configuration conf, Map<String, ContentSource> hostSourceMap, boolean fastLoad, AssignmentManager am) {
        super(conf, hostSourceMap, fastLoad, am);
        int arraySize = this.countBased ? 1 : this.forestIds.length;
        this.metadatas = new URIMetadata[arraySize][this.batchSize];
        this.isCopyProps = conf.getBoolean("mapreduce.marklogic.copyproperties", true);
        this.isCopyPerms = conf.getBoolean("mapreduce.marklogic.copypermissions", true);
        if (this.effectiveVersion >= 8000604L && this.isCopyProps) {
            this.propertyUris = new XdmValue[arraySize][this.batchSize];
            this.propertyXmlStrings = new XdmValue[arraySize][this.batchSize];
            this.propertyCounts = new int[arraySize];
        }
    }

    protected static ContentCreateOptions newContentCreateOptions(DocumentMetadata meta, ContentCreateOptions options, boolean isCopyColls, boolean isCopyQuality, boolean isCopyMeta, boolean isCopyPerms, long effectiveVersion) {
        ContentCreateOptions opt = (ContentCreateOptions)options.clone();
        if (meta != null) {
            if (isCopyQuality && opt.getQuality() == 0) {
                opt.setQuality(meta.quality);
            }
            if (isCopyColls) {
                if (opt.getCollections() != null) {
                    HashSet<String> colSet = new HashSet<String>(meta.collectionsList);
                    for (String string : opt.getCollections()) {
                        colSet.add(string);
                    }
                    opt.setCollections(colSet.toArray(new String[colSet.size()]));
                } else {
                    opt.setCollections(meta.getCollections());
                }
            }
            if (isCopyPerms) {
                if (effectiveVersion < 9000040L && meta.isNakedProps()) {
                    boolean reset = false;
                    Vector<ContentPermission> perms = new Vector<ContentPermission>();
                    for (ContentPermission perm : meta.permissionsList) {
                        if (!perm.getCapability().toString().equals(ContentPermission.NODE_UPDATE.toString())) {
                            perms.add(perm);
                            continue;
                        }
                        reset = true;
                    }
                    if (reset) {
                        meta.clearPermissions();
                        meta.addPermissions(perms);
                        meta.setPermString(null);
                    }
                }
                if (opt.getPermissions() != null) {
                    HashSet<ContentPermission> pSet = new HashSet<ContentPermission>(meta.permissionsList);
                    for (String string : opt.getPermissions()) {
                        pSet.add((ContentPermission)string);
                    }
                    opt.setPermissions(pSet.toArray(new ContentPermission[pSet.size()]));
                } else {
                    opt.setPermissions(meta.getPermissions());
                }
            }
            if (isCopyMeta) {
                opt.setMetadata(meta.meta);
            }
        }
        return opt;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void write(DocumentURI key, VALUE value) throws IOException, InterruptedException {
        String uri = InternalUtilities.getUriWithOutputDir((DocumentURI)key, (String)this.outputDir);
        int fId = 0;
        if (this.fastLoad) {
            if (!this.countBased) {
                this.sfId = fId = this.am.getPlacementForestIndex(key);
            } else {
                if (this.sfId == -1) {
                    this.sfId = this.am.getPlacementForestIndex(key);
                }
                fId = this.sfId;
            }
        }
        int sid = fId;
        Content content = null;
        DocumentMetadata meta = null;
        if (!(value instanceof DatabaseDocumentWithMeta)) throw new UnsupportedOperationException(value.getClass() + " is not supported.");
        try {
            meta = ((DatabaseDocumentWithMeta)((Object)value)).getMeta();
            ContentCreateOptions opt = DatabaseContentWriter.newContentCreateOptions(meta, this.options, this.isCopyColls, this.isCopyQuality, this.isCopyMeta, this.isCopyPerms, this.effectiveVersion);
            MarkLogicDocument doc = (MarkLogicDocument)value;
            if (meta == null || !meta.isNakedProps()) {
                opt.setFormat(doc.getContentType().getDocumentFormat());
                content = doc.getContentType() == ContentType.BINARY ? ContentFactory.newContent((String)uri, (byte[])doc.getContentAsByteArray(), (ContentCreateOptions)opt) : ContentFactory.newContent((String)uri, (String)doc.getContentAsText().toString(), (ContentCreateOptions)opt);
            }
        }
        catch (Exception e) {
            ++this.failed;
            LOG.warn((Object)("Failed document: " + uri));
            return;
        }
        if (this.countBased) {
            fId = 0;
        }
        this.pendingUris[sid].put(content, new DocumentURI(key));
        boolean inserted = false;
        if (meta == null || !meta.isNakedProps()) {
            this.forestContents[fId][this.counts[fId]] = content;
            if (this.propertyUris != null && meta != null && meta.getProperties() != null) {
                this.propertyUris[fId][this.propertyCounts[fId]] = ValueFactory.newValue((ValueType)ValueType.XS_STRING, (Object)uri);
                this.propertyXmlStrings[fId][this.propertyCounts[fId]] = ValueFactory.newValue((ValueType)ValueType.XS_STRING, (Object)meta.getProperties());
                int n = fId;
                this.propertyCounts[n] = this.propertyCounts[n] + 1;
                int n2 = fId;
                this.counts[n2] = this.counts[n2] + 1;
            } else {
                int n = fId;
                int n3 = this.counts[n];
                this.counts[n] = n3 + 1;
                this.metadatas[fId][n3] = new URIMetadata(uri, meta);
            }
        } else if (this.isCopyProps) {
            if (this.sessions[sid] == null) {
                this.sessions[sid] = this.getSession(sid, false);
            }
            boolean suc = DatabaseContentWriter.setDocumentProperties(uri, meta.getProperties(), this.isCopyPerms ? meta.getPermString() : null, this.isCopyColls ? meta.getCollectionString() : null, this.isCopyQuality ? meta.getQualityString() : null, this.isCopyMeta ? meta.getMeta() : null, this.sessions[sid]);
            int n = sid;
            this.stmtCounts[n] = this.stmtCounts[n] + 1;
            if (suc) {
                this.commitUris[sid].add(key);
            } else {
                ++this.failed;
            }
        }
        if (this.counts[fId] == this.batchSize) {
            if (this.sessions[sid] == null) {
                this.sessions[sid] = this.getSession(sid, false);
            }
            this.insertBatch(this.forestContents[fId], sid);
            int n = sid;
            this.stmtCounts[n] = this.stmtCounts[n] + 1;
            if (this.isCopyProps) {
                if (this.propertyUris != null) {
                    this.setBatchProperties(fId, this.sessions[sid]);
                    int n4 = sid;
                    this.stmtCounts[n4] = this.stmtCounts[n4] + 1;
                    this.propertyCounts[fId] = 0;
                } else {
                    for (int i = 0; i < this.counts[fId]; ++i) {
                        DocumentMetadata m = this.metadatas[fId][i].getMeta();
                        String u = this.metadatas[fId][i].getUri();
                        if (m == null || m.getProperties() == null) continue;
                        boolean suc = DatabaseContentWriter.setDocumentProperties(u, m.getProperties(), null, null, null, null, this.sessions[sid]);
                        int n5 = sid;
                        this.stmtCounts[n5] = this.stmtCounts[n5] + 1;
                        if (!suc) continue;
                        this.commitUris[sid].add(key);
                    }
                }
            }
            if (this.countBased) {
                this.sfId = -1;
            }
            this.counts[fId] = 0;
            inserted = true;
        }
        boolean committed = false;
        if (this.stmtCounts[sid] == this.txnSize && this.needCommit) {
            this.commit(sid);
            this.stmtCounts[sid] = 0;
            committed = true;
        }
        if (this.fastLoad || (!inserted || this.needCommit) && !committed) return;
        this.hostId = (this.hostId + 1) % this.forestIds.length;
        this.sessions[0] = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(TaskAttemptContext context) throws IOException, InterruptedException {
        if (this.batchSize > 1) {
            int sid;
            int len;
            if (this.countBased) {
                len = 1;
                sid = this.sfId;
            } else {
                len = this.fastLoad ? this.forestIds.length : 1;
                sid = 0;
            }
            int i = 0;
            while (i < len) {
                if (this.pendingUris[sid].size() > 0) {
                    Content[] remainder = new Content[this.counts[i]];
                    System.arraycopy(this.forestContents[i], 0, remainder, 0, this.counts[i]);
                    if (this.sessions[sid] == null) {
                        this.sessions[sid] = this.getSession(i, false);
                    }
                    try {
                        this.insertBatch(remainder, sid);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    int n = sid;
                    this.stmtCounts[n] = this.stmtCounts[n] + 1;
                    if (this.isCopyProps) {
                        if (this.propertyUris != null && this.propertyCounts[i] > 0) {
                            this.setBatchProperties(i, this.sessions[sid]);
                            int n2 = sid;
                            this.stmtCounts[n2] = this.stmtCounts[n2] + 1;
                        } else if (this.propertyUris == null) {
                            for (int j = 0; j < this.counts[i]; ++j) {
                                DocumentMetadata m = this.metadatas[i][j].getMeta();
                                String u = this.metadatas[i][j].getUri();
                                if (m == null || m.getProperties() == null) continue;
                                DatabaseContentWriter.setDocumentProperties(u, m.getProperties(), null, null, null, null, this.sessions[sid]);
                                int n3 = sid;
                                this.stmtCounts[n3] = this.stmtCounts[n3] + 1;
                            }
                        }
                    }
                }
                ++i;
                ++sid;
            }
        }
        for (int i = 0; i < this.sessions.length; ++i) {
            if (this.sessions[i] == null) continue;
            if (this.stmtCounts[i] > 0 && this.needCommit) {
                try {
                    this.sessions[i].commit();
                    this.succeeded += this.commitUris[i].size();
                    continue;
                }
                catch (RequestException e) {
                    LOG.error((Object)"Error commiting transaction", (Throwable)e);
                    this.failed += this.commitUris[i].size();
                    for (DocumentURI failedUri : this.commitUris[i]) {
                        LOG.warn((Object)("Failed document " + failedUri));
                    }
                    this.commitUris[i].clear();
                    continue;
                }
                finally {
                    this.sessions[i].close();
                }
            }
            this.sessions[i].close();
        }
        context.getCounter((Enum)MarkLogicCounter.OUTPUT_RECORDS_COMMITTED).increment((long)this.succeeded);
        context.getCounter((Enum)MarkLogicCounter.OUTPUT_RECORDS_FAILED).increment((long)this.failed);
    }

    protected boolean setBatchProperties(int i, Session s) {
        if (this.propertyCounts[i] == 0) {
            return true;
        }
        String query = "xquery version \"1.0-ml\";\ndeclare variable $URI as xs:string* external;\ndeclare variable $XML-STRING as xs:string* external;\nfor $docuri in $URI\nreturn(       \nxdmp:document-set-properties($docuri, xdmp:unquote(fn:head($XML-STRING))/prop:properties/node() ),\n    xdmp:set($XML-STRING, fn:tail($XML-STRING))\n    ); ";
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)query);
        }
        AdhocQuery req = s.newAdhocQuery(query);
        XdmValue[] uriArray = this.propertyUris[i];
        XdmValue[] xmlStringArray = this.propertyXmlStrings[i];
        if (this.propertyCounts[i] < this.batchSize) {
            uriArray = new XdmValue[this.propertyCounts[i]];
            xmlStringArray = new XdmValue[this.propertyCounts[i]];
            System.arraycopy(this.propertyUris[i], 0, uriArray, 0, this.propertyCounts[i]);
            System.arraycopy(this.propertyXmlStrings[i], 0, xmlStringArray, 0, this.propertyCounts[i]);
        }
        req.setNewVariables(new XName("URI"), uriArray);
        req.setNewVariables(new XName("XML-STRING"), xmlStringArray);
        try {
            s.submitRequest((Request)req);
            return true;
        }
        catch (RequestException ex) {
            for (XdmValue failedUri : uriArray) {
                LOG.error((Object)("Error batch setting document properties for: " + failedUri.asString()));
            }
            LOG.error((Object)ex.getMessage());
            return false;
        }
    }

    protected static boolean setDocumentProperties(String uri, String xmlString, String permString, String collString, String quality, Map<String, String> meta, Session s) {
        String query = "xquery version \"1.0-ml\";\ndeclare variable $URI as xs:string external;\ndeclare variable $XML-STRING as xs:string external;\ndeclare variable $PERM-STRING as xs:string external;\ndeclare variable $COLL-STRING as xs:string external;\ndeclare variable $QUALITY-STRING as xs:string external;\n" + (meta == null ? "" : "declare variable $META as map:map external;\n") + "xdmp:document-set-properties($URI,\n" + "  xdmp:unquote($XML-STRING)/prop:properties/node() )\n" + ", if('' eq ($PERM-STRING)) then () else \n" + "xdmp:document-set-permissions($URI, \n" + "xdmp:unquote($PERM-STRING)/node()/sec:permission)\n" + ", if('' eq ($COLL-STRING)) then () else \n" + "let $f := fn:function-lookup(xs:QName('xdmp:from-json-string'), 1)\n" + "return if (fn:exists($f)) then \n" + "xdmp:document-set-collections($URI,json:array-values($f($COLL-STRING)))\n" + "else xdmp:document-set-collections($URI,json:array-values(xdmp:from-json($COLL-STRING)))\n" + ", if('' eq ($QUALITY-STRING)) then () else xdmp:document-set-quality($URI,xs:integer($QUALITY-STRING))\n" + (meta == null ? "" : ", (let $f := fn:function-lookup(xs:QName('xdmp:document-set-metadata'),2)\nreturn if (exists($f)) then $f($URI,$META) else ())\n");
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)query);
        }
        AdhocQuery req = s.newAdhocQuery(query);
        req.setNewStringVariable("URI", uri);
        req.setNewStringVariable("XML-STRING", xmlString);
        req.setNewStringVariable("PERM-STRING", permString == null ? "" : permString);
        req.setNewStringVariable("COLL-STRING", collString == null || collString.isEmpty() ? "" : collString);
        req.setNewStringVariable("QUALITY-STRING", quality == null ? "" : quality);
        if (meta != null) {
            ObjectMapper mapper = new ObjectMapper();
            ObjectNode node = mapper.createObjectNode();
            for (Map.Entry<String, String> entry : meta.entrySet()) {
                node.put(entry.getKey(), entry.getValue());
            }
            req.setNewVariable("META", (ValueType)ValueType.JS_OBJECT, (Object)node);
        }
        try {
            s.submitRequest((Request)req);
            return true;
        }
        catch (RequestException ex) {
            LOG.error((Object)("Error setting document properties for " + uri + ": " + ex.getMessage()));
            return false;
        }
    }
}

