/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.contentpump;

import com.marklogic.contentpump.CombineDocumentReader;
import com.marklogic.contentpump.CombineDocumentSplit;
import com.marklogic.contentpump.FileAndDirectoryInputFormat;
import com.marklogic.mapreduce.DocumentURIWithSourceInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;

public class CombineDocumentInputFormat<VALUE>
extends FileAndDirectoryInputFormat<DocumentURIWithSourceInfo, VALUE> {
    public static final Log LOG = LogFactory.getLog(CombineDocumentInputFormat.class);

    @Override
    protected boolean isSplitable(JobContext context, Path filename) {
        return false;
    }

    public RecordReader<DocumentURIWithSourceInfo, VALUE> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        return new CombineDocumentReader();
    }

    @Override
    public List<InputSplit> getSplits(JobContext job) throws IOException {
        long minSize = Math.max(this.getFormatMinSplitSize(), CombineDocumentInputFormat.getMinSplitSize((JobContext)job));
        long maxSize = CombineDocumentInputFormat.getMaxSplitSize((JobContext)job);
        List<InputSplit> splits = super.getSplits(job);
        ArrayList<InputSplit> combinedSplits = new ArrayList<InputSplit>();
        CombineDocumentSplit split = null;
        int skippedEmptyFiles = 0;
        for (InputSplit file : splits) {
            Path path = ((FileSplit)file).getPath();
            FileSystem fs = path.getFileSystem(job.getConfiguration());
            FileStatus status = fs.getFileStatus(path);
            long length = status.getLen();
            long blockSize = status.getBlockSize();
            long splitSize = this.computeSplitSize(blockSize, minSize, maxSize);
            if (length != 0L) {
                if (split == null) {
                    split = new CombineDocumentSplit();
                }
                try {
                    if (split.getLength() + length < splitSize || split.getLength() < minSize) {
                        split.addSplit((FileSplit)file);
                        continue;
                    }
                    combinedSplits.add(split);
                    split = new CombineDocumentSplit();
                    split.addSplit((FileSplit)file);
                    continue;
                }
                catch (InterruptedException e) {
                    LOG.error((Object)e);
                    throw new RuntimeException(e);
                }
            }
            ++skippedEmptyFiles;
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Skipped empty file: " + path.toUri()));
        }
        if (split != null) {
            combinedSplits.add(split);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Total # of splits: " + splits.size()));
            LOG.debug((Object)("Total # of combined splits: " + combinedSplits.size()));
        }
        if (skippedEmptyFiles > 0) {
            LOG.warn((Object)("Total empty file skipped during getSplits: " + skippedEmptyFiles));
        }
        return combinedSplits;
    }
}

