/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.tree;

import com.marklogic.dom.AttrImpl;
import com.marklogic.dom.CommentImpl;
import com.marklogic.dom.DocumentImpl;
import com.marklogic.dom.ElementImpl;
import com.marklogic.dom.NodeImpl;
import com.marklogic.dom.ProcessingInstructionImpl;
import com.marklogic.dom.TextImpl;
import com.marklogic.tree.Capability;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;
import org.w3c.dom.Node;

public class ExpandedTree
implements Writable {
    public static final Log LOG = LogFactory.getLog(ExpandedTree.class);
    private static final Charset UTF8 = Charset.forName("UTF8");
    NodeImpl[] nodes;
    public long ordinal;
    public long uriKey;
    public long uniqKey;
    public long linkKey;
    public long[] keys;
    public byte[] atomData;
    public String[] atomString;
    public int[] atomIndex;
    public long[] nodeOrdinal;
    public byte[] nodeKind;
    public int[] nodeRepID;
    public int[] nodeParentNodeRepID;
    public int[] docNodeTextRepID;
    public int[] docNodeChildNodeRepID;
    public int[] docNodeNumChildren;
    public int[] elemNodeNodeNameRepID;
    public int[] elemNodeAttrNodeRepID;
    public int[] elemNodeChildNodeRepID;
    public int[] elemNodeElemDeclRepID;
    public int[] elemNodeNumAttributes;
    public int[] elemNodeNumDefaultAttrs;
    public int[] elemNodeNumChildren;
    public int[] elemNodeFlags;
    public int[] attrNodeNodeNameRepID;
    public int[] attrNodeTextRepID;
    public int[] attrNodeAttrDeclRepID;
    public int[] piNodeTargetAtom;
    public int[] piNodeTextRepID;
    public long[] linkNodeKey;
    public long[] linkNodeNodeCount;
    public int[] linkNodeNodeNameRepID;
    public int[] linkNodeNodeRepID;
    public int[] nodeNameNameAtom;
    public int[] nodeNameNamespaceAtom;
    public long[] nsNodeOrdinal;
    public int[] nsNodePrevNSNodeRepID;
    public int[] nsNodePrefixAtom;
    public int[] nsNodeUriAtom;
    public long[] permNodeOrdinal;
    public int[] permNodePrevPermNodeRepID;
    public Capability[] permNodeCapability;
    public long[] permNodeRoleId;
    public int[] arrayNodeTextRepID;
    public int[] arrayNodeChildNodeRepID;
    public int[] arrayNodeNumChildren;
    public double[] doubles;
    public long binaryKey;
    public long binaryOffset;
    public long binarySize;
    public long binaryOrigLen;
    public int binaryPathAtom;
    public int numTextReps;
    public int[] textReps;
    public int[] binaryData;
    public int atomLimit;
    public int numKeys;
    public int numNodeReps;
    public int numNSNodeReps;
    public int numPermNodeReps;
    public int numLinkNodeReps;
    public int uriTextRepID;
    public int colsTextRepID;
    public int[] metaKeys;
    public int[] metaVals;
    public int schemaRepUID;
    public long schemaTimestamp;
    public int numMetadata;
    private long fragmentOrdinal;
    private int quality;

    public boolean atomEquals(int atom, byte[] value) {
        int p = 0;
        int i = this.atomIndex[atom] + (this.atomData[this.atomIndex[atom]] >>> 7) + 1;
        while (p < value.length) {
            byte b = this.atomData[i];
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)String.format("%02x %02x", b, value[p]));
            }
            if (b == 0 || b != value[p]) {
                return false;
            }
            ++p;
            ++i;
        }
        return true;
    }

    public String atomString(int i) {
        if (i < 0 || i == Integer.MAX_VALUE) {
            return null;
        }
        String value = null;
        if (this.atomString == null) {
            this.atomString = new String[this.atomIndex.length];
        } else if (this.atomString.length > i) {
            value = this.atomString[i];
        }
        if (value == null) {
            int aidx = this.atomData[this.atomIndex[i]] >= 0 ? this.atomIndex[i] + 1 : this.atomIndex[i] + 2;
            value = this.atomString[i] = new String(this.atomData, aidx, this.atomIndex[i + 1] - aidx - 1, UTF8);
        }
        return value;
    }

    public String getText(int index) {
        int input = index;
        if (this.textReps == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        for (int i = this.textReps[index++]; i > 0; --i) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("atom " + this.textReps[index] + " [" + this.atomString(this.textReps[index]) + "] length " + this.atomString(this.textReps[index]).length()));
            }
            buf.append(this.atomString(this.textReps[index++]));
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("getText(" + input + ") returning [" + buf.toString() + "] length " + buf.length()));
        }
        return buf.toString();
    }

    public String[] getCollections() {
        int index = this.colsTextRepID;
        int cnt = this.textReps[index++];
        String[] cols = new String[cnt];
        for (int i = 0; i < cnt; ++i) {
            cols[i] = this.atomString(this.textReps[index++]);
        }
        return cols;
    }

    public Map<String, String> getMetadata() {
        if (this.numMetadata == 0) {
            return null;
        }
        HashMap<String, String> metaMap = new HashMap<String, String>(this.numMetadata);
        for (int i = 0; i < this.numMetadata; ++i) {
            metaMap.put(this.atomString(this.metaKeys[i]), this.getText(this.metaVals[i]));
        }
        return metaMap;
    }

    public byte rootNodeKind() {
        if (this.node(0) != null) {
            return this.nodeKind[((DocumentImpl)this.node(0)).getFirstChildIndex()];
        }
        return this.nodeKind[0];
    }

    public Node node(int i) {
        if (i == Integer.MAX_VALUE) {
            return null;
        }
        if (this.nodes[i] != null) {
            return this.nodes[i];
        }
        switch (this.nodeKind[i]) {
            case 0: {
                this.nodes[i] = new ElementImpl(this, i);
                break;
            }
            case 1: {
                this.nodes[i] = new AttrImpl(this, i);
                break;
            }
            case 2: {
                this.nodes[i] = new TextImpl(this, i);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                this.nodes[i] = new DocumentImpl(this, i);
                break;
            }
            case 6: {
                this.nodes[i] = new ProcessingInstructionImpl(this, i);
                break;
            }
            case 7: {
                this.nodes[i] = new CommentImpl(this, i);
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                break;
            }
            default: {
                LOG.warn((Object)("Unexpected node kind: " + this.nodeKind[i] + " @ " + i));
            }
        }
        return this.nodes[i];
    }

    public String getDocumentURI() {
        return this.getText(this.uriTextRepID);
    }

    public Path getPathToBinary() {
        long dirKey = this.binaryKey >>> 54;
        String dir = String.format("%03x", dirKey);
        String fileName = String.format("%016x", this.binaryKey);
        return new Path(dir, fileName);
    }

    public boolean containLinks() {
        return this.numLinkNodeReps > 0;
    }

    public long getFragmentOrdinal() {
        return this.fragmentOrdinal;
    }

    public void setFragmentOrdinal(long fragmentOrdinal) {
        this.fragmentOrdinal = fragmentOrdinal;
    }

    public int getQuality() {
        return this.quality;
    }

    public void setQuality(int quality) {
        this.quality = quality;
    }

    public void readFields(DataInput in) throws IOException {
        int numDoubles;
        int numArrayNodeReps;
        int i;
        int numPINodeReps;
        int numDocNodeReps;
        int i2;
        int numAttrNodeReps;
        int numElemNodeReps;
        int i3;
        int nodeNameNameAtomLen;
        int i4;
        int atomDataLen;
        this.uriKey = in.readLong();
        this.uniqKey = in.readLong();
        this.linkKey = in.readLong();
        this.numKeys = in.readInt();
        if (this.numKeys > 0) {
            this.keys = new long[this.numKeys];
            for (int i5 = 0; i5 < this.numKeys; ++i5) {
                this.keys[i5] = in.readLong();
            }
        }
        if ((atomDataLen = in.readInt()) > 0) {
            this.atomData = new byte[atomDataLen];
            for (i4 = 0; i4 < atomDataLen; ++i4) {
                this.atomData[i4] = in.readByte();
            }
        }
        this.atomLimit = in.readInt();
        if (this.atomLimit > 0) {
            this.atomIndex = new int[this.atomLimit + 1];
            for (i4 = 0; i4 < this.atomLimit + 1; ++i4) {
                this.atomIndex[i4] = in.readInt();
            }
        }
        if ((nodeNameNameAtomLen = in.readInt()) > 0) {
            this.nodeNameNameAtom = new int[nodeNameNameAtomLen];
            this.nodeNameNamespaceAtom = new int[nodeNameNameAtomLen];
            for (i3 = 0; i3 < nodeNameNameAtomLen; ++i3) {
                this.nodeNameNameAtom[i3] = in.readInt();
                this.nodeNameNamespaceAtom[i3] = in.readInt();
            }
        }
        this.numNodeReps = in.readInt();
        if (this.numNodeReps > 0) {
            this.nodes = new NodeImpl[this.numNodeReps];
            this.nodeOrdinal = new long[this.numNodeReps];
            this.nodeKind = new byte[this.numNodeReps];
            this.nodeRepID = new int[this.numNodeReps];
            this.nodeParentNodeRepID = new int[this.numNodeReps];
            for (i3 = 0; i3 < this.numNodeReps; ++i3) {
                this.nodeOrdinal[i3] = in.readLong();
                this.nodeKind[i3] = in.readByte();
                this.nodeRepID[i3] = in.readInt();
                this.nodeParentNodeRepID[i3] = in.readInt();
            }
        }
        if ((numElemNodeReps = in.readInt()) > 0) {
            this.elemNodeNodeNameRepID = new int[numElemNodeReps];
            this.elemNodeAttrNodeRepID = new int[numElemNodeReps];
            this.elemNodeChildNodeRepID = new int[numElemNodeReps];
            this.elemNodeElemDeclRepID = new int[numElemNodeReps];
            this.elemNodeNumAttributes = new int[numElemNodeReps];
            this.elemNodeNumDefaultAttrs = new int[numElemNodeReps];
            this.elemNodeNumChildren = new int[numElemNodeReps];
            this.elemNodeFlags = new int[numElemNodeReps];
            for (int i6 = 0; i6 < numElemNodeReps; ++i6) {
                this.elemNodeNodeNameRepID[i6] = in.readInt();
                this.elemNodeAttrNodeRepID[i6] = in.readInt();
                this.elemNodeChildNodeRepID[i6] = in.readInt();
                this.elemNodeElemDeclRepID[i6] = in.readInt();
                this.elemNodeNumAttributes[i6] = in.readInt();
                this.elemNodeNumDefaultAttrs[i6] = in.readInt();
                this.elemNodeNumChildren[i6] = in.readInt();
                this.elemNodeFlags[i6] = in.readInt();
            }
        }
        if ((numAttrNodeReps = in.readInt()) > 0) {
            this.attrNodeNodeNameRepID = new int[numAttrNodeReps];
            this.attrNodeTextRepID = new int[numAttrNodeReps];
            this.attrNodeAttrDeclRepID = new int[numAttrNodeReps];
            for (i2 = 0; i2 < numAttrNodeReps; ++i2) {
                this.attrNodeNodeNameRepID[i2] = in.readInt();
                this.attrNodeTextRepID[i2] = in.readInt();
                this.attrNodeAttrDeclRepID[i2] = in.readInt();
            }
        }
        this.numLinkNodeReps = in.readInt();
        if (this.numLinkNodeReps > 0) {
            this.linkNodeKey = new long[this.numLinkNodeReps];
            this.linkNodeNodeCount = new long[this.numLinkNodeReps];
            this.linkNodeNodeNameRepID = new int[this.numLinkNodeReps];
            this.linkNodeNodeRepID = new int[this.numLinkNodeReps];
            for (i2 = 0; i2 < this.numLinkNodeReps; ++i2) {
                this.linkNodeKey[i2] = in.readLong();
                this.linkNodeNodeCount[i2] = in.readLong();
                this.linkNodeNodeNameRepID[i2] = in.readInt();
                this.linkNodeNodeRepID[i2] = in.readInt();
            }
        }
        if ((numDocNodeReps = in.readInt()) > 0) {
            this.docNodeTextRepID = new int[numDocNodeReps];
            this.docNodeChildNodeRepID = new int[numDocNodeReps];
            this.docNodeNumChildren = new int[numDocNodeReps];
            for (int i7 = 0; i7 < numDocNodeReps; ++i7) {
                this.docNodeTextRepID[i7] = in.readInt();
                this.docNodeChildNodeRepID[i7] = in.readInt();
                this.docNodeNumChildren[i7] = in.readInt();
            }
        }
        if ((numPINodeReps = in.readInt()) > 0) {
            this.piNodeTargetAtom = new int[numPINodeReps];
            this.piNodeTextRepID = new int[numPINodeReps];
            for (i = 0; i < numPINodeReps; ++i) {
                this.piNodeTargetAtom[i] = in.readInt();
                this.piNodeTextRepID[i] = in.readInt();
            }
        }
        this.numNSNodeReps = in.readInt();
        if (this.numNSNodeReps > 0) {
            this.nsNodeOrdinal = new long[this.numNSNodeReps];
            this.nsNodePrevNSNodeRepID = new int[this.numNSNodeReps];
            this.nsNodePrefixAtom = new int[this.numNSNodeReps];
            this.nsNodeUriAtom = new int[this.numNSNodeReps];
            for (i = 0; i < this.numNSNodeReps; ++i) {
                this.nsNodeOrdinal[i] = in.readLong();
                this.nsNodePrevNSNodeRepID[i] = in.readInt();
                this.nsNodePrefixAtom[i] = in.readInt();
                this.nsNodeUriAtom[i] = in.readInt();
            }
        }
        this.uriTextRepID = in.readInt();
        this.colsTextRepID = in.readInt();
        this.numTextReps = in.readInt();
        if (this.numTextReps > 0) {
            this.textReps = new int[this.numTextReps];
            for (i = 0; i < this.numTextReps; ++i) {
                this.textReps[i] = in.readInt();
            }
        }
        if ((numArrayNodeReps = in.readInt()) > 0) {
            this.arrayNodeTextRepID = new int[numArrayNodeReps];
            this.arrayNodeChildNodeRepID = new int[numArrayNodeReps];
            this.arrayNodeNumChildren = new int[numArrayNodeReps];
            for (int i8 = 0; i8 < numArrayNodeReps; ++i8) {
                this.arrayNodeTextRepID[i8] = in.readInt();
                this.arrayNodeChildNodeRepID[i8] = in.readInt();
                this.arrayNodeNumChildren[i8] = in.readInt();
            }
        }
        if ((numDoubles = in.readInt()) > 0) {
            this.doubles = new double[numDoubles];
            for (int i9 = 0; i9 < numDoubles; ++i9) {
                this.doubles[i9] = in.readDouble();
            }
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeLong(this.uriKey);
        out.writeLong(this.uniqKey);
        out.writeLong(this.linkKey);
        out.writeInt(this.numKeys);
        if (this.numKeys > 0) {
            for (long key : this.keys) {
                out.writeLong(key);
            }
        }
        if (this.atomData != null && this.atomData.length > 0) {
            out.writeInt(this.atomData.length);
            for (int i = 0; i < this.atomData.length; ++i) {
                out.writeByte(this.atomData[i]);
            }
        } else {
            out.writeInt(0);
        }
        out.writeInt(this.atomLimit);
        if (this.atomIndex != null && this.atomIndex.length > 0) {
            for (int i = 0; i < this.atomIndex.length; ++i) {
                out.writeInt(this.atomIndex[i]);
            }
        }
        if (this.nodeNameNameAtom != null && this.nodeNameNameAtom.length > 0) {
            out.writeInt(this.nodeNameNameAtom.length);
            for (int i = 0; i < this.nodeNameNameAtom.length; ++i) {
                out.writeInt(this.nodeNameNameAtom[i]);
                out.writeInt(this.nodeNameNamespaceAtom[i]);
            }
        } else {
            out.writeInt(0);
        }
        out.writeInt(this.numNodeReps);
        if (this.numNodeReps > 0) {
            for (int i = 0; i < this.numNodeReps; ++i) {
                out.writeLong(this.nodeOrdinal[i]);
                out.writeByte(this.nodeKind[i]);
                out.writeInt(this.nodeRepID[i]);
                out.writeInt(this.nodeParentNodeRepID[i]);
            }
        }
        if (this.elemNodeNodeNameRepID != null && this.elemNodeNodeNameRepID.length > 0) {
            out.writeInt(this.elemNodeNodeNameRepID.length);
            for (int i = 0; i < this.elemNodeNodeNameRepID.length; ++i) {
                out.writeInt(this.elemNodeNodeNameRepID[i]);
                out.writeInt(this.elemNodeAttrNodeRepID[i]);
                out.writeInt(this.elemNodeChildNodeRepID[i]);
                out.writeInt(this.elemNodeElemDeclRepID[i]);
                out.writeInt(this.elemNodeNumAttributes[i]);
                out.writeInt(this.elemNodeNumDefaultAttrs[i]);
                out.writeInt(this.elemNodeNumChildren[i]);
                out.writeInt(this.elemNodeFlags[i]);
            }
        } else {
            out.writeInt(0);
        }
        if (this.attrNodeNodeNameRepID != null && this.attrNodeNodeNameRepID.length > 0) {
            out.writeInt(this.attrNodeNodeNameRepID.length);
            for (int i = 0; i < this.attrNodeNodeNameRepID.length; ++i) {
                out.writeInt(this.attrNodeNodeNameRepID[i]);
                out.writeInt(this.attrNodeTextRepID[i]);
                out.writeInt(this.attrNodeAttrDeclRepID[i]);
            }
        } else {
            out.writeInt(0);
        }
        out.writeInt(this.numLinkNodeReps);
        if (this.numLinkNodeReps > 0) {
            for (int i = 0; i < this.numLinkNodeReps; ++i) {
                out.writeLong(this.linkNodeKey[i]);
                out.writeLong(this.linkNodeNodeCount[i]);
                out.writeInt(this.linkNodeNodeNameRepID[i]);
                out.writeInt(this.linkNodeNodeRepID[i]);
            }
        }
        if (this.docNodeTextRepID != null && this.docNodeTextRepID.length > 0) {
            out.writeInt(this.docNodeTextRepID.length);
            for (int i = 0; i < this.docNodeTextRepID.length; ++i) {
                out.writeInt(this.docNodeTextRepID[i]);
                out.writeInt(this.docNodeChildNodeRepID[i]);
                out.writeInt(this.docNodeNumChildren[i]);
            }
        } else {
            out.writeInt(0);
        }
        if (this.piNodeTargetAtom != null && this.piNodeTargetAtom.length > 0) {
            out.writeInt(this.piNodeTargetAtom.length);
            for (int i = 0; i < this.piNodeTargetAtom.length; ++i) {
                out.writeInt(this.piNodeTargetAtom[i]);
                out.writeInt(this.piNodeTextRepID[i]);
            }
        } else {
            out.writeInt(0);
        }
        out.writeInt(this.numNSNodeReps);
        if (this.numNSNodeReps > 0) {
            for (int i = 0; i < this.numNSNodeReps; ++i) {
                out.writeLong(this.nsNodeOrdinal[i]);
                out.writeInt(this.nsNodePrevNSNodeRepID[i]);
                out.writeInt(this.nsNodePrefixAtom[i]);
                out.writeInt(this.nsNodeUriAtom[i]);
            }
        }
        out.writeInt(this.uriTextRepID);
        out.writeInt(this.colsTextRepID);
        out.writeInt(this.numTextReps);
        if (this.numTextReps > 0) {
            for (int i = 0; i < this.numTextReps; ++i) {
                out.writeInt(this.textReps[i]);
            }
        }
        if (this.arrayNodeTextRepID != null && this.arrayNodeTextRepID.length > 0) {
            out.writeInt(this.arrayNodeTextRepID.length);
            for (int i = 0; i < this.arrayNodeTextRepID.length; ++i) {
                out.writeInt(this.arrayNodeTextRepID[i]);
                out.writeInt(this.arrayNodeChildNodeRepID[i]);
                out.writeInt(this.arrayNodeNumChildren[i]);
            }
        } else {
            out.writeInt(0);
        }
        if (this.doubles != null && this.doubles.length > 0) {
            out.writeInt(this.doubles.length);
            for (int i = 0; i < this.doubles.length; ++i) {
                out.writeDouble(this.doubles[i]);
            }
        } else {
            out.writeInt(0);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.putNode(0, sb);
        return sb.toString();
    }

    public void putNode(int index, StringBuilder sb) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)String.format("putNode index %d nodeKind %d", index, this.nodeKind[index]));
        }
        switch (this.nodeKind[index]) {
            case 2: {
                sb.append("\"");
                int id = this.nodeRepID[index];
                sb.append(this.getText(id));
                sb.append("\"");
                break;
            }
            case 5: {
                int id = this.nodeRepID[index];
                int limit = this.docNodeChildNodeRepID[id] + this.docNodeNumChildren[id];
                for (int i = this.docNodeChildNodeRepID[id]; i < limit; ++i) {
                    this.putNode(i, sb);
                }
                break;
            }
            case 10: {
                sb.append("null");
                break;
            }
            case 11: {
                if (this.nodeRepID[index] == 1) {
                    sb.append("true");
                    break;
                }
                sb.append("false");
                break;
            }
            case 12: {
                sb.append(String.valueOf(this.doubles[this.nodeRepID[index]]));
                break;
            }
            case 13: {
                sb.append("[");
                int id = this.nodeRepID[index];
                int limit = this.arrayNodeChildNodeRepID[id] + this.arrayNodeNumChildren[id];
                int i = 0;
                int idx = this.arrayNodeChildNodeRepID[id];
                while (idx < limit) {
                    if (i != 0) {
                        sb.append(", ");
                    }
                    this.putNode(idx, sb);
                    ++idx;
                    ++i;
                }
                sb.append("]");
                break;
            }
            case 14: {
                sb.append("{ ");
                int id = this.nodeRepID[index];
                int limit = this.arrayNodeChildNodeRepID[id] + this.arrayNodeNumChildren[id];
                int i = 0;
                int idx = this.arrayNodeChildNodeRepID[id];
                while (idx < limit) {
                    if (i != 0) {
                        sb.append(", ");
                    }
                    sb.append("\"");
                    sb.append(this.atomString(this.textReps[this.arrayNodeTextRepID[id] + i]));
                    sb.append("\" : ");
                    this.putNode(idx, sb);
                    ++idx;
                    ++i;
                }
                sb.append(" }");
                break;
            }
            default: {
                sb.append("node:UNKNOWN ");
            }
        }
    }
}

