/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mapreduce.test;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;

class ZipContentReader
extends RecordReader<Text, Text> {
    private Text key = new Text();
    private Text value = new Text();
    private ZipInputStream zipIn;
    private byte[] buf = new byte[65536];
    private boolean hasNext = true;

    ZipContentReader() {
    }

    public void close() throws IOException {
        if (this.zipIn != null) {
            this.zipIn.close();
        }
    }

    public Text getCurrentKey() throws IOException, InterruptedException {
        return this.key;
    }

    public Text getCurrentValue() throws IOException, InterruptedException {
        return this.value;
    }

    public float getProgress() throws IOException, InterruptedException {
        return this.hasNext ? 0.0f : 1.0f;
    }

    public void initialize(InputSplit inSplit, TaskAttemptContext context) throws IOException, InterruptedException {
        Path file = ((FileSplit)inSplit).getPath();
        FileSystem fs = file.getFileSystem(context.getConfiguration());
        FSDataInputStream fileIn = fs.open(file);
        this.zipIn = new ZipInputStream((InputStream)fileIn);
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        if (this.zipIn != null) {
            ZipEntry zipEntry;
            while ((zipEntry = this.zipIn.getNextEntry()) != null) {
                long size;
                if (zipEntry == null) continue;
                this.key.set(zipEntry.getName());
                StringBuilder entry = new StringBuilder();
                while ((size = (long)this.zipIn.read(this.buf, 0, this.buf.length)) != -1L) {
                    entry.append(new String(this.buf, 0, (int)size));
                }
                this.value.set(entry.toString());
                return true;
            }
            this.hasNext = false;
            return false;
        }
        this.hasNext = false;
        return false;
    }
}

