/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mapreduce.functions;

import com.marklogic.mapreduce.functions.LexiconFunction;
import com.marklogic.mapreduce.functions.Words;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public abstract class ValuesOrWordsFunction
extends LexiconFunction {
    public String getStart() {
        return "()";
    }

    abstract void appendFunctionName(StringBuilder var1);

    abstract void appendNamesParams(StringBuilder var1);

    @Override
    public String getInputQuery(Collection<String> nsCol, long start, long count) {
        long end = count == Long.MAX_VALUE ? count : start + count;
        StringBuilder buf = new StringBuilder();
        buf.append("xquery version \"1.0-ml\"; \n");
        buf.append("xdmp:with-namespaces((");
        if (nsCol != null) {
            Iterator<String> nsIt = nsCol.iterator();
            while (nsIt.hasNext()) {
                String ns = nsIt.next();
                buf.append('\"').append(ns).append('\"');
                if (!nsIt.hasNext()) continue;
                buf.append(',');
            }
        }
        buf.append("),");
        this.appendFunctionName(buf);
        buf.append("(");
        this.appendNamesParams(buf);
        buf.append(this.getStart());
        buf.append(",(");
        String[] userOptions = this.getUserDefinedOptions();
        if (userOptions != null) {
            for (int i = 0; i < userOptions.length; ++i) {
                if (i != 0) {
                    buf.append(",");
                }
                buf.append("\"").append(userOptions[i]).append("\"");
            }
        }
        buf.append("),");
        buf.append(this.getLexiconQuery()).append("))");
        buf.append("[").append(start).append(" to ");
        buf.append(end).append("]");
        return buf.toString();
    }

    public static void main(String[] args) {
        WordsFunction wordsFunc = new WordsFunction();
        ArrayList<String> nsbindings = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            nsbindings.add(args[i]);
        }
        System.out.println(wordsFunc.getInputQuery(nsbindings, 1L, 1000L));
    }

    static class WordsFunction
    extends Words {
        WordsFunction() {
        }

        @Override
        public String[] getUserDefinedOptions() {
            String[] options = new String[]{"document", "concurrent"};
            return options;
        }
    }
}

