/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mapreduce.examples;

import com.marklogic.mapreduce.ContentOutputFormat;
import com.marklogic.mapreduce.DocumentURI;
import com.marklogic.mapreduce.examples.ContentInputFormat;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.util.GenericOptionsParser;

public class ContentLoader {
    public static void main(String[] args) throws Exception {
        Configuration conf = new Configuration();
        if (args.length < 2) {
            System.err.println("Usage: ContentLoader configFile inputDir");
            System.exit(2);
        }
        String[] otherArgs = new GenericOptionsParser(conf, args).getRemainingArgs();
        Job job = Job.getInstance((Configuration)conf, (String)"content loader");
        job.setJarByClass(ContentLoader.class);
        job.setInputFormatClass(ContentInputFormat.class);
        job.setMapperClass(ContentMapper.class);
        job.setMapOutputKeyClass(DocumentURI.class);
        job.setMapOutputValueClass(Text.class);
        job.setOutputFormatClass(ContentOutputFormat.class);
        ContentInputFormat.setInputPaths((Job)job, (Path[])new Path[]{new Path(otherArgs[1])});
        conf = job.getConfiguration();
        conf.addResource(otherArgs[0]);
        System.exit(job.waitForCompletion(true) ? 0 : 1);
    }

    public static class ContentMapper
    extends Mapper<Text, Text, DocumentURI, Text> {
        private DocumentURI uri = new DocumentURI();

        public void map(Text fileName, Text fileContent, Mapper.Context context) throws IOException, InterruptedException {
            this.uri.setUri(fileName.toString());
            context.write((Object)this.uri, (Object)fileContent);
        }
    }
}

