/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mapreduce;

import com.marklogic.mapreduce.CompressionCodec;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;

public class StreamLocator
implements Writable {
    private Path path;
    private CompressionCodec codec;

    public StreamLocator() {
    }

    public StreamLocator(Path path, CompressionCodec codec) {
        this.path = path;
        this.codec = codec;
    }

    public Path getPath() {
        return this.path;
    }

    public void setPath(Path path) {
        this.path = path;
    }

    public CompressionCodec getCodec() {
        return this.codec;
    }

    public void setCodec(CompressionCodec codec) {
        this.codec = codec;
    }

    public void readFields(DataInput in) throws IOException {
        this.path = new Path(Text.readString((DataInput)in));
        this.codec = (CompressionCodec)WritableUtils.readEnum((DataInput)in, CompressionCodec.class);
    }

    public void write(DataOutput out) throws IOException {
        Text.writeString((DataOutput)out, (String)this.path.toString());
        WritableUtils.writeEnum((DataOutput)out, (Enum)this.codec);
    }

    public String toString() {
        return "path: " + this.path + ", codec: " + (Object)((Object)this.codec);
    }
}

