/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mapreduce;

import com.marklogic.mapreduce.MarkLogicConstants;
import com.marklogic.mapreduce.MarkLogicNode;
import com.marklogic.mapreduce.MarkLogicRecordWriter;
import com.marklogic.mapreduce.NodeOpType;
import com.marklogic.mapreduce.NodePath;
import com.marklogic.xcc.AdhocQuery;
import com.marklogic.xcc.Request;
import com.marklogic.xcc.Session;
import com.marklogic.xcc.exceptions.RequestException;
import com.marklogic.xcc.types.ValueType;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;

public class NodeWriter
extends MarkLogicRecordWriter<NodePath, MarkLogicNode>
implements MarkLogicConstants {
    public static final Log LOG = LogFactory.getLog(NodeWriter.class);
    public static final String NODE_VARIABLE_NAME = "node";
    public static final String PATH_VARIABLE_NAME = "path";
    private String query;

    public NodeWriter(Configuration conf, String host) {
        super(conf, host);
        String opTypeStr = conf.get("mapreduce.marklogic.output.node.optype");
        if (opTypeStr == null || opTypeStr.isEmpty()) {
            throw new IllegalArgumentException("mapreduce.marklogic.output.node.optype is not specified.");
        }
        NodeOpType opType = NodeOpType.valueOf(opTypeStr);
        Collection nsCol = conf.getStringCollection("mapreduce.marklogic.output.node.namespace");
        StringBuilder buf = new StringBuilder();
        if (nsCol != null) {
            Iterator nsIt = nsCol.iterator();
            while (nsIt.hasNext()) {
                String ns = (String)nsIt.next();
                buf.append('\"').append(ns).append('\"');
                if (!nsIt.hasNext()) continue;
                buf.append(',');
            }
        }
        this.query = opType.getQuery(buf.toString());
    }

    public void write(NodePath path, MarkLogicNode record) throws IOException, InterruptedException {
        if (record == null || record.get() == null) {
            throw new UnsupportedOperationException("Record node is null.");
        }
        if (record.get().getNodeType() != 1) {
            throw new UnsupportedOperationException("Unsupported node type: " + record.get().getNodeType());
        }
        String recordString = record.toString();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)this.query);
        }
        Session session = this.getSession();
        try {
            AdhocQuery request = session.newAdhocQuery(this.query);
            request.setNewStringVariable(PATH_VARIABLE_NAME, path.getFullPath());
            request.setNewVariable(NODE_VARIABLE_NAME, (ValueType)ValueType.ELEMENT, (Object)recordString);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("path: " + path.getFullPath()));
                LOG.debug((Object)("node: " + recordString));
            }
            session.submitRequest((Request)request);
            this.commitIfNecessary();
        }
        catch (RequestException e) {
            LOG.error((Object)e);
            LOG.error((Object)this.query);
            throw new IOException(e);
        }
    }
}

