/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mapreduce;

import com.marklogic.io.BiendianDataInputStream;
import com.marklogic.mapreduce.DocumentURIWithSourceInfo;
import com.marklogic.mapreduce.ForestDocument;
import com.marklogic.mapreduce.MarkLogicConstants;
import com.marklogic.mapreduce.utilities.URIUtil;
import com.marklogic.tree.CompressedTreeDecoder;
import com.marklogic.tree.ExpandedTree;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;

public class ForestReader<VALUEIN>
extends RecordReader<DocumentURIWithSourceInfo, VALUEIN>
implements MarkLogicConstants {
    public static final Log LOG = LogFactory.getLog(ForestReader.class);
    protected FileSplit split;
    protected long bytesRead;
    protected Configuration conf;
    protected BiendianDataInputStream dataIs;
    protected BiendianDataInputStream ordIs;
    protected BiendianDataInputStream tsIs;
    protected BiendianDataInputStream qualIs;
    protected DocumentURIWithSourceInfo key;
    protected VALUEIN value;
    protected Class<? extends Writable> valueClass;
    protected int position;
    protected int prevDocid = -1;
    protected boolean done = false;
    protected Path largeForestDir;
    protected int nascentCnt = 0;
    protected int deletedCnt = 0;
    protected int fragCnt = 0;
    protected Collection<String> colFilters;
    protected Collection<String> dirFilters;
    protected Collection<String> typeFilters;
    protected String srcId = null;

    public void close() throws IOException {
        if (this.dataIs != null) {
            this.dataIs.close();
        }
        if (this.ordIs != null) {
            this.ordIs.close();
        }
        if (this.tsIs != null) {
            this.tsIs.close();
        }
        if (this.qualIs != null) {
            this.qualIs.close();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Nascent count: " + this.nascentCnt + " Deleted count: " + this.deletedCnt + " Bytes read = " + this.bytesRead + " Fragment count: " + this.fragCnt + " Last docid: " + this.prevDocid));
        }
    }

    public DocumentURIWithSourceInfo getCurrentKey() throws IOException, InterruptedException {
        return this.key;
    }

    public VALUEIN getCurrentValue() throws IOException, InterruptedException {
        return this.value;
    }

    public float getProgress() throws IOException, InterruptedException {
        return this.done ? 1.0f : (float)this.bytesRead / (float)this.split.getLength();
    }

    public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        this.split = (FileSplit)split;
        this.conf = context.getConfiguration();
        Path dataPath = this.split.getPath();
        FileSystem fs = dataPath.getFileSystem(this.conf);
        this.dataIs = new BiendianDataInputStream((InputStream)fs.open(dataPath));
        this.dataIs.skipBytes(this.split.getStart());
        Path ordPath = new Path(dataPath.getParent(), "Ordinals");
        this.ordIs = new BiendianDataInputStream((InputStream)fs.open(ordPath));
        Path qualPath = new Path(dataPath.getParent(), "Qualities");
        this.qualIs = new BiendianDataInputStream((InputStream)fs.open(qualPath));
        Path tsPath = new Path(dataPath.getParent(), "Timestamps");
        this.tsIs = new BiendianDataInputStream((InputStream)fs.open(tsPath));
        this.valueClass = this.conf.getClass("mapreduce.marklogic.input.valueclass", ForestDocument.class, Writable.class);
        if (!ForestDocument.class.isAssignableFrom(this.valueClass)) {
            throw new IllegalArgumentException("Unsupported mapreduce.marklogic.input.valueclass");
        }
        this.largeForestDir = new Path(dataPath.getParent().getParent(), "Large");
        this.colFilters = this.conf.getStringCollection("mapreduce.marklogic.input.filter.collection");
        this.dirFilters = this.conf.getStringCollection("mapreduce.marklogic.input.filter.directory");
        ArrayList<String> addedDirs = null;
        Iterator<String> it = this.dirFilters.iterator();
        while (it.hasNext()) {
            String dir = it.next();
            if (dir.endsWith("/")) continue;
            String newDir = dir + "/";
            it.remove();
            if (addedDirs == null) {
                addedDirs = new ArrayList<String>();
            }
            addedDirs.add(newDir);
        }
        if (addedDirs != null) {
            this.dirFilters.addAll(addedDirs);
        }
        this.typeFilters = this.conf.getStringCollection("mapreduce.marklogic.input.filter.type");
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        while (this.bytesRead < this.split.getLength() && !this.done) {
            ExpandedTree tree = this.getNextTree();
            if (tree == null) continue;
            String uri = tree.getDocumentURI();
            if (tree.containLinks() || tree.getFragmentOrdinal() != 0L) {
                this.setSkipKey(uri, 0, 0, "fragment or link");
                this.value = null;
                return true;
            }
            if (!this.applyFilter(uri, tree)) continue;
            this.value = ForestDocument.createDocument(this.conf, this.largeForestDir, tree, uri);
            if (this.value == null) {
                this.setSkipKey(uri, 0, 0, "unsupported node type");
                return true;
            }
            this.setKey(uri, uri, 0, 0);
            return true;
        }
        return false;
    }

    protected void setKey(String uri, String sub, int line, int col) {
        if (this.srcId == null) {
            this.srcId = this.split.getPath().toString();
        }
        uri = URIUtil.applyUriReplace(uri, this.conf);
        uri = URIUtil.applyPrefixSuffix(uri, this.conf);
        if (this.key == null) {
            this.key = new DocumentURIWithSourceInfo(uri, this.srcId, sub, line, col);
        } else {
            this.key.setSkipReason("");
            this.key.setUri(uri);
            this.key.setSrcId(this.srcId);
            this.key.setSubId(sub);
            this.key.setColNumber(col);
            this.key.setLineNumber(line);
        }
    }

    protected void setSkipKey(String sub, int line, int col, String reason) {
        if (this.srcId == null) {
            this.srcId = this.split.getPath().toString();
        }
        if (this.key == null) {
            this.key = new DocumentURIWithSourceInfo("", this.srcId, sub, line, col);
        } else {
            this.key.setUri("");
            this.key.setSrcId(this.srcId);
            this.key.setSubId(sub);
            this.key.setColNumber(col);
            this.key.setLineNumber(line);
        }
        this.key.setSkipReason(reason);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Set key: " + this.key));
        }
    }

    protected boolean applyFilter(String uri, ExpandedTree tree) {
        if (!this.dirFilters.isEmpty()) {
            boolean match = false;
            for (String dir : this.dirFilters) {
                if (!uri.startsWith(dir)) continue;
                match = true;
                break;
            }
            if (!match) {
                return false;
            }
        }
        if (!this.typeFilters.isEmpty()) {
            byte kind = tree.rootNodeKind();
            boolean match = false;
            for (String type : this.typeFilters) {
                if (type.equalsIgnoreCase("BINARY") && kind == 9) {
                    match = true;
                    break;
                }
                if (type.equalsIgnoreCase("TEXT") && kind == 2) {
                    match = true;
                    break;
                }
                if (type.equalsIgnoreCase("JSON") && (kind == 13 || kind == 14)) {
                    match = true;
                    break;
                }
                if (!type.equalsIgnoreCase("XML") || kind != 0 && kind != 7 && kind != 6) continue;
                match = true;
                break;
            }
            if (!match) {
                return false;
            }
        }
        if (!this.colFilters.isEmpty()) {
            String[] cols = tree.getCollections();
            boolean match = false;
            for (String col : cols) {
                if (!this.colFilters.contains(col)) continue;
                match = true;
                break;
            }
            if (!match) {
                return false;
            }
        }
        return true;
    }

    private ExpandedTree getNextTree() throws IOException {
        int j;
        try {
            int docid = this.dataIs.readInt();
            int csword = this.dataIs.readInt();
            int fdatw = this.dataIs.readInt();
            this.bytesRead += 12L;
            int datWords = csword & 0xF;
            int hdrWords = 2;
            if (datWords == 0) {
                datWords = fdatw;
                hdrWords = 3;
                LOG.trace((Object)"3 header words");
            }
            if (docid == -1 && csword == -1 && fdatw == -1) {
                LOG.trace((Object)"Reached the end");
                this.done = true;
                return null;
            }
            if (this.prevDocid != -1 && docid <= this.prevDocid) {
                throw new RuntimeException("docid out of order, postition = " + this.position + ", docid = " + docid + ", prevDocid = " + this.prevDocid);
            }
            if (this.prevDocid == -1 && docid != 0) {
                this.ordIs.skipBytes(docid * 8);
                this.tsIs.skipBytes(docid * 8 * 2);
                this.qualIs.skipBytes(docid * 4);
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("First docid: " + docid));
                }
            } else {
                int docidDiff = docid - this.prevDocid;
                if (docidDiff > 1) {
                    int toSkip = docidDiff * 8;
                    this.ordIs.skipBytes(toSkip);
                    this.tsIs.skipBytes(toSkip * 2);
                    this.qualIs.skipBytes(docidDiff * 4);
                }
            }
            this.prevDocid = docid;
            j = hdrWords == 2 ? datWords - 1 : datWords;
            j *= 4;
            ++this.fragCnt;
            long nascent = this.tsIs.readLong();
            long deleted = this.tsIs.readLong();
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)String.format("TreeData p %d d %d w %d nt %d dt %d", this.position, docid, datWords, nascent, deleted));
            }
            if (nascent == 0L || deleted != -1L) {
                this.bytesRead += (long)this.dataIs.skipBytes(j);
                if (nascent == 0L) {
                    ++this.nascentCnt;
                }
                if (deleted != -1L) {
                    ++this.deletedCnt;
                }
                this.ordIs.skipBytes(8);
                this.qualIs.skipBytes(4);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Skipped a " + (nascent == 0L ? "nascent" : "deleted") + " document at position " + this.position));
                }
                ++this.position;
                return null;
            }
        }
        catch (EOFException e) {
            this.done = true;
            return null;
        }
        try {
            byte[] buf = new byte[j];
            InputStream in = this.dataIs.getInputStream();
            for (int read = 0; read < j; read += in.read(buf, read, j - read)) {
            }
            this.bytesRead += (long)j;
            ++this.position;
            ExpandedTree tree = new CompressedTreeDecoder().decode(buf, j);
            tree.setFragmentOrdinal(this.ordIs.readLong());
            tree.setQuality(this.qualIs.readInt());
            return tree;
        }
        catch (Exception e) {
            LOG.error((Object)"Unexpected error occurred reading forest data", (Throwable)e);
            this.done = true;
            return null;
        }
    }
}

