/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mapreduce;

import com.marklogic.mapreduce.DOMDocument;
import com.marklogic.mapreduce.JSONDocument;
import com.marklogic.mapreduce.LargeBinaryDocument;
import com.marklogic.mapreduce.MarkLogicDocument;
import com.marklogic.mapreduce.RegularBinaryDocument;
import com.marklogic.tree.ExpandedTree;
import com.marklogic.xcc.Content;
import com.marklogic.xcc.ContentCreateOptions;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.WritableUtils;

public abstract class ForestDocument
implements MarkLogicDocument {
    public static final Log LOG = LogFactory.getLog(ForestDocument.class);
    private long fragmentOrdinal;
    private String[] collections;
    private int quality;
    private Map<String, String> metadata = null;

    public static ForestDocument createDocument(Configuration conf, Path forestDir, ExpandedTree tree, String uri) {
        byte rootNodeKind = tree.rootNodeKind();
        ForestDocument doc = null;
        switch (rootNodeKind) {
            case 9: {
                if (tree.binaryData == null) {
                    doc = new LargeBinaryDocument(conf, forestDir, tree);
                    break;
                }
                doc = new RegularBinaryDocument(tree);
                break;
            }
            case 0: 
            case 2: 
            case 6: 
            case 7: {
                doc = new DOMDocument(tree);
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Creating JSONDocument " + rootNodeKind + " (" + uri + ")"));
                }
                doc = new JSONDocument(tree);
                break;
            }
            default: {
                return null;
            }
        }
        super.setFragmentOrdinal(tree.getFragmentOrdinal());
        super.setCollections(tree.getDocumentURI(), tree.getCollections());
        doc.setMetadata(tree.getMetadata());
        doc.setQuality(tree.getQuality());
        return doc;
    }

    public long getFragmentOrdinal() {
        return this.fragmentOrdinal;
    }

    private void setFragmentOrdinal(long fragOrdinal) {
        this.fragmentOrdinal = fragOrdinal;
    }

    public String[] getCollections() {
        return this.collections;
    }

    private void setCollections(String docURI, String[] cols) {
        ArrayList<String> colList = new ArrayList<String>(cols.length);
        for (String col : cols) {
            if (col.isEmpty()) {
                LOG.info((Object)("Empty collection URI is removed for document " + docURI));
                continue;
            }
            colList.add(col);
        }
        this.collections = new String[colList.size()];
        colList.toArray(this.collections);
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    private void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.fragmentOrdinal = in.readLong();
        this.collections = WritableUtils.readStringArray((DataInput)in);
        int numMetadata = in.readInt();
        if (numMetadata > 0) {
            String[] metaStrings = WritableUtils.readStringArray((DataInput)in);
            this.metadata = new HashMap<String, String>(numMetadata);
            for (int i = 0; i < metaStrings.length - 1; ++i) {
                this.metadata.put(metaStrings[i], metaStrings[i + 1]);
            }
        }
        this.quality = in.readInt();
    }

    public int getQuality() {
        return this.quality;
    }

    public void setQuality(int quality) {
        this.quality = quality;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeLong(this.fragmentOrdinal);
        WritableUtils.writeStringArray((DataOutput)out, (String[])this.collections);
        if (this.metadata == null || this.metadata.isEmpty()) {
            out.writeInt(0);
        } else {
            out.writeInt(this.metadata.size());
            String[] metaStrings = new String[this.metadata.size() * 2];
            int i = 0;
            for (Map.Entry<String, String> entry : this.metadata.entrySet()) {
                metaStrings[i++] = entry.getKey();
                metaStrings[i++] = entry.getValue();
            }
            WritableUtils.writeStringArray((DataOutput)out, (String[])metaStrings);
        }
        out.writeInt(this.quality);
    }

    @Override
    public InputStream getContentAsByteStream() {
        return new ByteArrayInputStream(this.getContentAsByteArray());
    }

    @Override
    public long getContentSize() {
        byte[] buf = this.getContentAsByteArray();
        return buf.length;
    }

    @Override
    public boolean isStreamable() {
        return false;
    }

    public abstract Content createContent(String var1, ContentCreateOptions var2, boolean var3, boolean var4, boolean var5) throws IOException;

    protected void setContentOptions(ContentCreateOptions options, boolean copyCollections, boolean copyMetadata, boolean copyQuality) {
        if (copyCollections && this.collections.length != 0) {
            String[] cols = options.getCollections();
            if (cols == null || cols.length == 0) {
                options.setCollections(this.collections);
            } else {
                HashSet<String> colsSet = new HashSet<String>();
                if (cols != null) {
                    for (String col : cols) {
                        colsSet.add(col);
                    }
                }
                for (String col : this.collections) {
                    colsSet.add(col);
                }
                String[] newCols = new String[colsSet.size()];
                colsSet.toArray(newCols);
                options.setCollections(newCols);
            }
        }
        if (copyMetadata) {
            options.setMetadata(this.metadata);
        }
        if (copyQuality) {
            options.setQuality(this.quality);
        }
    }
}

