/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mapreduce;

import com.marklogic.mapreduce.ContentType;
import com.marklogic.mapreduce.CustomContent;
import com.marklogic.mapreduce.DatabaseDocument;
import com.marklogic.mapreduce.DocumentURI;
import com.marklogic.mapreduce.ForestDocument;
import com.marklogic.mapreduce.LinkedMapWritable;
import com.marklogic.mapreduce.MarkLogicConstants;
import com.marklogic.mapreduce.MarkLogicCounter;
import com.marklogic.mapreduce.MarkLogicNode;
import com.marklogic.mapreduce.MarkLogicRecordWriter;
import com.marklogic.mapreduce.StreamLocator;
import com.marklogic.mapreduce.ZipEntryInputStream;
import com.marklogic.mapreduce.utilities.AssignmentManager;
import com.marklogic.mapreduce.utilities.AssignmentPolicy;
import com.marklogic.mapreduce.utilities.InternalUtilities;
import com.marklogic.mapreduce.utilities.StatisticalAssignmentPolicy;
import com.marklogic.xcc.Content;
import com.marklogic.xcc.ContentCapability;
import com.marklogic.xcc.ContentCreateOptions;
import com.marklogic.xcc.ContentFactory;
import com.marklogic.xcc.ContentPermission;
import com.marklogic.xcc.ContentSource;
import com.marklogic.xcc.DocumentFormat;
import com.marklogic.xcc.DocumentRepairLevel;
import com.marklogic.xcc.RequestOptions;
import com.marklogic.xcc.Session;
import com.marklogic.xcc.exceptions.ContentInsertException;
import com.marklogic.xcc.exceptions.QueryException;
import com.marklogic.xcc.exceptions.RequestException;
import com.marklogic.xcc.exceptions.RequestServerException;
import com.marklogic.xcc.impl.SessionImpl;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.w3c.dom.Node;

public class ContentWriter<VALUEOUT>
extends MarkLogicRecordWriter<DocumentURI, VALUEOUT>
implements MarkLogicConstants {
    public static final Log LOG = LogFactory.getLog(ContentWriter.class);
    public static final String ID_PREFIX = "#";
    protected String outputDir;
    protected ContentCreateOptions options;
    protected Map<String, ContentSource> hostSourceMap;
    protected Content[][] forestContents;
    protected String[] forestIds;
    protected int[] curReplica;
    protected boolean[] blacklist;
    protected int[] counts;
    protected HashMap<Content, DocumentURI>[] pendingUris;
    protected List<DocumentURI>[] commitUris;
    protected boolean fastLoad;
    protected int batchSize;
    protected int[] stmtCounts;
    protected Session[] sessions;
    private boolean formatNeeded;
    private FileSystem fs;
    protected InputStream is;
    private boolean streaming;
    private RequestOptions requestOptions;
    protected AssignmentManager am;
    protected int sfId;
    protected boolean countBased;
    protected LinkedMapWritable roleMap;
    protected HashMap<String, ContentPermission[]> permsMap;
    protected int succeeded = 0;
    protected int failed = 0;
    protected boolean needCommit = false;
    protected int hostId = 0;
    protected boolean isCopyColls;
    protected boolean isCopyQuality;
    protected boolean isCopyMeta;
    protected long effectiveVersion;
    protected boolean isTxnCompatible = false;
    protected int retry;
    protected final int maxRetries = 15;
    protected int sleepTime;
    protected final int maxSleepTime = 30000;

    public ContentWriter(Configuration conf, Map<String, ContentSource> hostSourceMap, boolean fastLoad) {
        this(conf, hostSourceMap, fastLoad, null);
    }

    public ContentWriter(Configuration conf, Map<String, ContentSource> hostSourceMap, boolean fastLoad, AssignmentManager am) {
        super(conf, null);
        String contentTypeStr;
        ContentType contentType;
        int i;
        int srcMapSize;
        this.effectiveVersion = am.getEffectiveVersion();
        this.isTxnCompatible = this.effectiveVersion == 0L;
        this.fastLoad = fastLoad;
        this.hostSourceMap = hostSourceMap;
        this.am = am;
        this.requestOptions = new RequestOptions();
        this.requestOptions.setMaxAutoRetry(0);
        this.permsMap = new HashMap();
        if (fastLoad) {
            this.forestIds = (String[])am.getMasterIds().clone();
            srcMapSize = this.forestIds.length;
            this.curReplica = new int[srcMapSize];
            for (i = 0; i < srcMapSize; ++i) {
                this.curReplica[i] = 0;
            }
        } else {
            srcMapSize = hostSourceMap.size();
            this.forestIds = new String[srcMapSize];
            this.forestIds = hostSourceMap.keySet().toArray(this.forestIds);
            this.blacklist = new boolean[srcMapSize];
            for (i = 0; i < srcMapSize; ++i) {
                this.blacklist[i] = false;
            }
        }
        this.hostId = (int)(Math.random() * (double)srcMapSize);
        int arraySize = fastLoad ? srcMapSize : 1;
        this.sessions = new Session[arraySize];
        this.stmtCounts = new int[arraySize];
        this.outputDir = conf.get("mapreduce.marklogic.output.content.directory");
        this.batchSize = conf.getInt("mapreduce.marklogic.output.batchsize", 100);
        this.pendingUris = new HashMap[arraySize];
        for (int i2 = 0; i2 < arraySize; ++i2) {
            this.pendingUris[i2] = new HashMap();
        }
        if (fastLoad && (am.getPolicy().getPolicyKind() == AssignmentPolicy.Kind.STATISTICAL || am.getPolicy().getPolicyKind() == AssignmentPolicy.Kind.RANGE || am.getPolicy().getPolicyKind() == AssignmentPolicy.Kind.QUERY)) {
            this.countBased = true;
            this.forestContents = new Content[1][this.batchSize];
            this.counts = new int[1];
            this.sfId = -1;
        } else {
            this.forestContents = new Content[arraySize][this.batchSize];
            this.counts = new int[arraySize];
            this.sfId = 0;
        }
        String[] perms = conf.getStrings("mapreduce.marklogic.output.content.permission");
        ArrayList<ContentPermission> permissions = null;
        if (perms != null && perms.length > 0) {
            int i3 = 0;
            while (i3 + 1 < perms.length) {
                String roleName;
                if ((roleName = perms[i3++]) == null || roleName.isEmpty()) {
                    LOG.error((Object)("Illegal role name: " + roleName));
                    continue;
                }
                String perm = perms[i3].trim();
                ContentCapability capability = null;
                if (perm.equalsIgnoreCase(ContentCapability.READ.toString())) {
                    capability = ContentCapability.READ;
                } else if (perm.equalsIgnoreCase(ContentCapability.EXECUTE.toString())) {
                    capability = ContentCapability.EXECUTE;
                } else if (perm.equalsIgnoreCase(ContentCapability.INSERT.toString())) {
                    capability = ContentCapability.INSERT;
                } else if (perm.equalsIgnoreCase(ContentCapability.UPDATE.toString())) {
                    capability = ContentCapability.UPDATE;
                } else if (perm.equalsIgnoreCase(ContentCapability.NODE_UPDATE.toString())) {
                    capability = ContentCapability.NODE_UPDATE;
                } else {
                    LOG.error((Object)("Illegal permission: " + perm));
                }
                if (capability != null) {
                    if (permissions == null) {
                        permissions = new ArrayList<ContentPermission>();
                    }
                    permissions.add(new ContentPermission(capability, roleName));
                }
                ++i3;
            }
        }
        this.options = new ContentCreateOptions();
        String[] collections = conf.getStrings("mapreduce.marklogic.output.content.collection");
        if (collections != null) {
            for (int i4 = 0; i4 < collections.length; ++i4) {
                collections[i4] = collections[i4].trim();
            }
            this.options.setCollections(collections);
        }
        this.options.setQuality(conf.getInt("mapreduce.marklogic.output.content.quality", 0));
        if (permissions != null) {
            this.options.setPermissions(permissions.toArray(new ContentPermission[permissions.size()]));
        }
        if ((contentType = ContentType.valueOf(contentTypeStr = conf.get("mapreduce.marklogic.output.content.type", "XML"))) == ContentType.UNKNOWN) {
            this.formatNeeded = true;
        } else {
            this.options.setFormat(contentType.getDocumentFormat());
        }
        this.options.setLanguage(conf.get("mapreduce.marklogic.output.content.language"));
        String repairLevel = conf.get("mapreduce.marklogic.output.content.repairlevel", "DEFAULT").toLowerCase();
        this.options.setNamespace(conf.get("mapreduce.marklogic.output.content.namespace"));
        if (DocumentRepairLevel.DEFAULT.toString().equals(repairLevel)) {
            this.options.setRepairLevel(DocumentRepairLevel.DEFAULT);
        } else if (DocumentRepairLevel.NONE.toString().equals(repairLevel)) {
            this.options.setRepairLevel(DocumentRepairLevel.NONE);
        } else if (DocumentRepairLevel.FULL.toString().equals(repairLevel)) {
            this.options.setRepairLevel(DocumentRepairLevel.FULL);
        }
        this.streaming = conf.getBoolean("mapreduce.marklogic.output.content.streaming", false);
        String encoding = conf.get("mapreduce.marklogic.output.content.encoding");
        if (encoding != null) {
            this.options.setEncoding(encoding);
        }
        this.options.setTemporalCollection(conf.get("mapreduce.marklogic.output.temporalcollection"));
        this.needCommit = this.needCommit();
        if (this.needCommit) {
            this.commitUris = new ArrayList[arraySize];
            for (int i5 = 0; i5 < arraySize; ++i5) {
                this.commitUris[i5] = new ArrayList<DocumentURI>(this.txnSize * this.batchSize);
            }
        }
        this.isCopyColls = conf.getBoolean("mapreduce.marklogic.copycollections", true);
        this.isCopyQuality = conf.getBoolean("mapreduce.marklogic.copyquality", true);
        this.isCopyMeta = conf.getBoolean("mapreduce.marklogic.copymetadata", true);
    }

    protected boolean needCommit() {
        return true;
    }

    protected Content createContent(DocumentURI key, VALUEOUT value) throws IOException {
        String uri = key.getUri();
        Content content = null;
        if (value instanceof Text) {
            if (this.formatNeeded) {
                this.options.setFormat(DocumentFormat.TEXT);
                this.formatNeeded = false;
            }
            this.options.setEncoding("UTF-8");
            content = ContentFactory.newContent((String)uri, (byte[])((Text)value).getBytes(), (int)0, (int)((Text)value).getLength(), (ContentCreateOptions)this.options);
        } else if (value instanceof MarkLogicNode) {
            if (this.formatNeeded) {
                this.options.setFormat(DocumentFormat.XML);
                this.formatNeeded = false;
            }
            content = ContentFactory.newContent((String)uri, (Node)((MarkLogicNode)value).get(), (ContentCreateOptions)this.options);
        } else if (value instanceof ForestDocument) {
            ContentCreateOptions newOptions = this.options;
            if (this.isCopyColls || this.isCopyMeta || this.isCopyQuality) {
                newOptions = (ContentCreateOptions)this.options.clone();
            }
            content = ((ForestDocument)value).createContent(uri, newOptions, this.isCopyColls, this.isCopyMeta, this.isCopyQuality);
        } else if (value instanceof BytesWritable) {
            if (this.formatNeeded) {
                this.options.setFormat(DocumentFormat.BINARY);
                this.formatNeeded = false;
            }
            content = ContentFactory.newContent((String)uri, (byte[])((BytesWritable)value).getBytes(), (int)0, (int)((BytesWritable)value).getLength(), (ContentCreateOptions)this.options);
        } else if (value instanceof CustomContent) {
            ContentCreateOptions newOptions = this.options;
            newOptions = (ContentCreateOptions)this.options.clone();
            content = ((CustomContent)value).getContent(this.conf, newOptions, uri);
        } else if (value instanceof DatabaseDocument) {
            DatabaseDocument doc = (DatabaseDocument)value;
            if (this.formatNeeded) {
                this.options.setFormat(doc.getContentType().getDocumentFormat());
                this.formatNeeded = false;
            }
            this.options.setEncoding("UTF-8");
            content = doc.getContentType() == ContentType.BINARY ? ContentFactory.newContent((String)uri, (byte[])doc.getContentAsByteArray(), (ContentCreateOptions)this.options) : ContentFactory.newContent((String)uri, (byte[])doc.getContentAsText().getBytes(), (ContentCreateOptions)this.options);
        } else if (value instanceof StreamLocator) {
            Path path = ((StreamLocator)value).getPath();
            if (this.fs == null) {
                URI fileUri = path.toUri();
                this.fs = FileSystem.get((URI)fileUri, (Configuration)this.conf);
            }
            switch (((StreamLocator)value).getCodec()) {
                case GZIP: {
                    FSDataInputStream fileIn = this.fs.open(path);
                    this.is = new GZIPInputStream((InputStream)fileIn);
                    break;
                }
                case ZIP: {
                    if (this.is != null) break;
                    FSDataInputStream zipfileIn = this.fs.open(path);
                    ZipInputStream zis = new ZipInputStream((InputStream)zipfileIn);
                    this.is = new ZipEntryInputStream(zis, path.toString());
                    break;
                }
                case NONE: {
                    this.is = this.fs.open(path);
                    break;
                }
                default: {
                    LOG.error((Object)("Unsupported compression codec: " + (Object)((Object)((StreamLocator)value).getCodec()) + " for document " + key));
                    return content;
                }
            }
            content = this.streaming ? ContentFactory.newUnBufferedContent((String)uri, (InputStream)this.is, (ContentCreateOptions)this.options) : ContentFactory.newContent((String)uri, (InputStream)this.is, (ContentCreateOptions)this.options);
        } else {
            throw new UnsupportedOperationException(value.getClass() + " is not supported.");
        }
        return content;
    }

    protected void insertBatch(Content[] batch, int id) throws IOException {
        this.retry = 0;
        this.sleepTime = 500;
        while (this.retry < 15) {
            try {
                List errors;
                if (this.retry == 1) {
                    LOG.info((Object)"Retrying document insert");
                }
                if ((errors = this.sessions[id].insertContentCollectErrors(batch)) != null) {
                    for (RequestException ex : errors) {
                        Throwable cause = ex.getCause();
                        if (cause != null) {
                            if (cause instanceof QueryException) {
                                LOG.error((Object)((QueryException)cause).getFormatString());
                            } else {
                                LOG.error((Object)cause.getMessage());
                            }
                        }
                        if (!(ex instanceof ContentInsertException)) continue;
                        Content content = ((ContentInsertException)ex).getContent();
                        DocumentURI failedUri = this.pendingUris[id].remove(content);
                        ++this.failed;
                        if (failedUri == null) continue;
                        LOG.warn((Object)("Failed document " + failedUri));
                    }
                }
                if (this.retry <= 0) break;
                LOG.debug((Object)"Retry successful");
                break;
            }
            catch (Exception e) {
                boolean retryable = true;
                if (e instanceof QueryException) {
                    LOG.error((Object)("QueryException:" + ((QueryException)e).getFormatString()));
                    retryable = ((QueryException)e).isRetryable();
                } else if (e instanceof RequestServerException) {
                    LOG.error((Object)("RequestServerException:" + e.getMessage()));
                } else {
                    LOG.error((Object)("Exception:" + e.getMessage()));
                }
                if (this.needCommit) {
                    this.rollback(id);
                }
                if (retryable && ++this.retry < 15) {
                    this.sessions[id].close();
                    try {
                        InternalUtilities.sleep(this.sleepTime);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.sleepTime *= 2;
                    if (this.sleepTime > 30000) {
                        this.sleepTime = 30000;
                    }
                    this.sessions[id] = this.getSession(id, true);
                    continue;
                }
                if (retryable) {
                    LOG.info((Object)"Exceeded max retry");
                }
                this.failed += batch.length;
                for (Content fc : batch) {
                    DocumentURI failedUri = this.pendingUris[id].remove(fc);
                    LOG.warn((Object)("Failed document " + failedUri));
                }
                throw new IOException(e);
            }
        }
        if (this.needCommit) {
            for (DocumentURI uri : this.pendingUris[id].values()) {
                this.commitUris[id].add(uri);
            }
        } else {
            this.succeeded += this.pendingUris[id].size();
        }
        this.pendingUris[id].clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rollback(int id) throws IOException {
        try {
            this.sessions[id].rollback();
        }
        catch (Exception e) {
            LOG.error((Object)("Error rolling back transaction " + e.getMessage()));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)e);
            }
        }
        finally {
            if (this.countBased) {
                this.rollbackCount(id);
            }
            this.failed += this.commitUris[id].size();
            for (DocumentURI failedUri : this.commitUris[id]) {
                LOG.warn((Object)("Failed document: " + failedUri));
            }
            this.commitUris[id].clear();
        }
    }

    protected void commit(int id) throws IOException {
        try {
            this.sessions[id].commit();
            this.succeeded += this.commitUris[id].size();
            this.commitUris[id].clear();
        }
        catch (Exception e) {
            LOG.error((Object)("Error commiting transaction " + e.getMessage()));
            this.rollback(id);
            this.sessions[id].close();
            this.sessions[id] = null;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void write(DocumentURI key, VALUEOUT value) throws IOException, InterruptedException {
        InternalUtilities.getUriWithOutputDir(key, this.outputDir);
        fId = 0;
        if (this.fastLoad) {
            if (!this.countBased) {
                this.sfId = fId = this.am.getPlacementForestIndex(key);
            } else {
                if (this.sfId == -1) {
                    this.sfId = this.am.getPlacementForestIndex(key);
                }
                fId = this.sfId;
            }
        }
        sid = fId;
        content = this.createContent(key, value);
        if (content == null) {
            ++this.failed;
            return;
        }
        if (this.countBased) {
            fId = 0;
        }
        this.pendingUris[sid].put(content, (DocumentURI)key.clone());
        inserted = false;
        v0 = fId;
        v1 = this.counts[v0];
        this.counts[v0] = v1 + 1;
        this.forestContents[fId][v1] = content;
        if (this.counts[fId] == this.batchSize) {
            if (this.sessions[sid] == null) {
                this.sessions[sid] = this.getSession(sid, false);
            }
            this.insertBatch(this.forestContents[fId], sid);
            v2 = sid;
            this.stmtCounts[v2] = this.stmtCounts[v2] + 1;
            if (this.countBased) {
                this.sfId = -1;
            }
            this.counts[fId] = 0;
            inserted = true;
        }
        committed = false;
        if (this.needCommit && this.stmtCounts[sid] == this.txnSize) {
            this.commit(sid);
            this.stmtCounts[sid] = 0;
            committed = true;
        }
        if (!this.fastLoad && (inserted && !this.needCommit || committed)) {
            oldHostId = this.hostId;
            block0: while (true) {
                this.hostId = (this.hostId + 1) % this.forestIds.length;
                if (!this.blacklist[this.hostId]) break;
                if (this.hostId != oldHostId) continue;
                i = 0;
                while (true) {
                    if (i < this.blacklist.length) ** break;
                    continue block0;
                    this.blacklist[i] = false;
                    ++i;
                }
                break;
            }
            this.sessions[0] = null;
        }
    }

    protected void rollbackCount(int fId) {
        ((StatisticalAssignmentPolicy)this.am.getPolicy()).updateStats(fId, -this.batchSize);
    }

    /*
     * Unable to fully structure code
     */
    protected Session getSession(int fId, boolean nextReplica, Session.TransactionMode mode) {
        session = null;
        if (this.fastLoad) {
            replicas = this.am.getReplicas(this.forestIds[fId]);
            if (nextReplica) {
                this.curReplica[fId] = (this.curReplica[fId] + 1) % replicas.size();
            }
            cs = this.hostSourceMap.get(replicas.get(this.curReplica[fId]).getHostName());
            forestId = replicas.get(this.curReplica[fId]).getForest();
            session = cs.newSession("#" + forestId);
            if (ContentWriter.LOG.isDebugEnabled()) {
                ContentWriter.LOG.debug((Object)("Connect to forest " + forestId + " on " + session.getConnectionUri().getHost()));
            }
        } else {
            if (nextReplica) {
                this.blacklist[this.hostId] = true;
                oldHostId = this.hostId;
                block0: while (true) {
                    this.hostId = (this.hostId + 1) % this.forestIds.length;
                    if (!this.blacklist[this.hostId]) break;
                    if (this.hostId != oldHostId) continue;
                    i = 0;
                    while (true) {
                        if (i < this.blacklist.length) ** break;
                        continue block0;
                        this.blacklist[i] = false;
                        ++i;
                    }
                    break;
                }
            }
            forestId = this.forestIds[this.hostId];
            cs = this.hostSourceMap.get(forestId);
            session = cs.newSession();
            if (ContentWriter.LOG.isDebugEnabled()) {
                ContentWriter.LOG.debug((Object)("Connect to " + session.getConnectionUri().getHost()));
            }
        }
        session.setTransactionMode(mode);
        session.setDefaultRequestOptions(this.requestOptions);
        ((SessionImpl)session).setCompatibleMode(this.isTxnCompatible);
        return session;
    }

    protected Session getSession(int fId, boolean nextReplica) {
        Session.TransactionMode mode = Session.TransactionMode.AUTO;
        if (this.needCommit) {
            mode = Session.TransactionMode.UPDATE;
        }
        return this.getSession(fId, nextReplica, mode);
    }

    @Override
    public void close(TaskAttemptContext context) throws IOException, InterruptedException {
        if (this.batchSize > 1) {
            int sid;
            int len;
            if (this.countBased) {
                len = 1;
                sid = this.sfId;
            } else {
                len = this.fastLoad ? this.forestIds.length : 1;
                sid = 0;
            }
            int i = 0;
            while (i < len) {
                if (sid != -1 && this.pendingUris[sid].size() > 0) {
                    Content[] remainder = new Content[this.counts[i]];
                    System.arraycopy(this.forestContents[i], 0, remainder, 0, this.counts[i]);
                    if (this.sessions[sid] == null) {
                        this.sessions[sid] = this.getSession(sid, false);
                    }
                    try {
                        this.insertBatch(remainder, sid);
                    }
                    catch (Throwable e) {
                        LOG.error((Object)"Error caught inserting documents: ", e);
                    }
                    int n = sid;
                    this.stmtCounts[n] = this.stmtCounts[n] + 1;
                }
                ++i;
                ++sid;
            }
        }
        for (int i = 0; i < this.sessions.length; ++i) {
            if (this.sessions[i] == null) continue;
            if (this.stmtCounts[i] > 0 && this.needCommit) {
                try {
                    this.commit(i);
                    if (this.sessions[i] == null) continue;
                    this.sessions[i].close();
                }
                catch (Throwable e) {
                    LOG.error((Object)"Error committing transaction: ", e);
                }
                continue;
            }
            this.sessions[i].close();
        }
        if (this.is != null) {
            this.is.close();
            if (this.is instanceof ZipEntryInputStream) {
                ((ZipEntryInputStream)this.is).closeZipInputStream();
            }
        }
        context.getCounter((Enum)MarkLogicCounter.OUTPUT_RECORDS_COMMITTED).increment((long)this.succeeded);
        context.getCounter((Enum)MarkLogicCounter.OUTPUT_RECORDS_FAILED).increment((long)this.failed);
    }

    @Override
    public int getTransactionSize(Configuration conf) {
        if (conf.get("mapreduce.marklogic.output.transactionsize") != null) {
            int txnSize = conf.getInt("mapreduce.marklogic.output.transactionsize", 0);
            return txnSize <= 0 ? 1 : txnSize;
        }
        return 1;
    }
}

