/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.dom;

import com.marklogic.dom.DocumentTypeImpl;
import com.marklogic.dom.NodeImpl;
import com.marklogic.tree.ExpandedTree;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class DocumentImpl
extends NodeImpl
implements Document {
    public static final Log LOG = LogFactory.getLog(DocumentImpl.class);
    private Element documentElement;
    private Document ownerDocCloned;
    private static DocumentBuilderFactory dbf = null;
    private int isXMLDoc = -1;
    static final int UNKNOWN_TYPE = -1;
    static final int VALID_XML = 0;
    static final int NON_XML = 1;

    public DocumentImpl(ExpandedTree tree, int node) {
        super(tree, node);
    }

    private static synchronized DocumentBuilderFactory getDocumentBuilderFactory() {
        if (dbf == null) {
            dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
        }
        return dbf;
    }

    @Override
    public Node cloneNode(boolean deep) {
        try {
            if (this.isXMLDoc == -1) {
                this.isXMLDoc = this.getDocumentType();
            }
            if (this.isXMLDoc == 1) {
                throw new UnsupportedOperationException("Text document cannot be cloned");
            }
            this.initClonedOwnerDoc();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("Internal Error:" + e);
        }
        if (deep) {
            for (NodeImpl n = (NodeImpl)this.getFirstChild(); n != null; n = (NodeImpl)n.getNextSibling()) {
                this.ownerDocCloned.appendChild(n.cloneNode(this.ownerDocCloned, true));
            }
        }
        return this.ownerDocCloned;
    }

    protected void initClonedOwnerDoc() throws ParserConfigurationException {
        this.ownerDocCloned = DocumentImpl.getDocumentBuilderFactory().newDocumentBuilder().newDocument();
        this.ownerDocCloned.setDocumentURI(this.getDocumentURI());
        this.ownerDocCloned.setXmlVersion(this.getXmlVersion());
    }

    public boolean isXMLDoc() {
        if (this.isXMLDoc == -1) {
            this.isXMLDoc = this.getDocumentType();
        }
        return this.isXMLDoc == 0;
    }

    private int getDocumentType() {
        NodeList children = this.getChildNodes();
        int elemCount = 0;
        block4: for (int i = 0; i < children.getLength(); ++i) {
            Node n = children.item(i);
            switch (n.getNodeType()) {
                case 1: {
                    ++elemCount;
                    continue block4;
                }
                case 7: 
                case 8: {
                    continue block4;
                }
                default: {
                    return 1;
                }
            }
        }
        return elemCount <= 1 ? 0 : 1;
    }

    @Override
    public String getNodeName() {
        return "#document";
    }

    @Override
    public Document getOwnerDocument() {
        return null;
    }

    protected int getNumChildren() {
        return this.tree.docNodeNumChildren[this.tree.nodeRepID[this.node]];
    }

    public int getFirstChildIndex() {
        return this.tree.docNodeChildNodeRepID[this.tree.nodeRepID[this.node]];
    }

    @Override
    public NodeList getChildNodes() {
        return new NodeList(){

            @Override
            public int getLength() {
                return DocumentImpl.this.getNumChildren();
            }

            @Override
            public Node item(int index) {
                return index < DocumentImpl.this.getNumChildren() ? DocumentImpl.this.tree.node(DocumentImpl.this.getFirstChildIndex() + index) : null;
            }
        };
    }

    @Override
    public Node getFirstChild() {
        int i = this.getFirstChildIndex();
        return i != Integer.MAX_VALUE ? this.tree.node(i) : null;
    }

    @Override
    public Node getLastChild() {
        int i = this.tree.docNodeChildNodeRepID[this.tree.nodeRepID[this.node]];
        return i != Integer.MAX_VALUE ? this.tree.node(i + this.tree.docNodeNumChildren[this.node] - 1) : null;
    }

    @Override
    public boolean hasChildNodes() {
        return this.getFirstChildIndex() != Integer.MAX_VALUE;
    }

    @Override
    protected Node getNextChild(int child) {
        if (child - this.getFirstChildIndex() + 1 < this.getNumChildren()) {
            return this.tree.node(child + 1);
        }
        return null;
    }

    @Override
    protected Node getPreviousChild(int node) {
        if (node != this.getFirstChildIndex()) {
            return this.tree.node(node - 1);
        }
        return null;
    }

    @Override
    public Node adoptNode(Node arg0) throws DOMException {
        throw new DOMException(7, null);
    }

    @Override
    public Attr createAttribute(String arg0) throws DOMException {
        throw new DOMException(7, null);
    }

    @Override
    public Attr createAttributeNS(String arg0, String arg1) throws DOMException {
        throw new DOMException(7, null);
    }

    @Override
    public CDATASection createCDATASection(String arg0) throws DOMException {
        throw new DOMException(7, null);
    }

    @Override
    public Comment createComment(String arg0) {
        throw new DOMException(7, null);
    }

    @Override
    public DocumentFragment createDocumentFragment() {
        throw new DOMException(7, null);
    }

    @Override
    public Element createElement(String arg0) throws DOMException {
        throw new DOMException(7, null);
    }

    @Override
    public Element createElementNS(String arg0, String arg1) throws DOMException {
        throw new DOMException(7, null);
    }

    @Override
    public EntityReference createEntityReference(String arg0) throws DOMException {
        throw new DOMException(7, null);
    }

    @Override
    public ProcessingInstruction createProcessingInstruction(String arg0, String arg1) throws DOMException {
        throw new DOMException(7, null);
    }

    @Override
    public Text createTextNode(String arg0) {
        throw new DOMException(7, null);
    }

    @Override
    public DocumentType getDoctype() {
        return new DocumentTypeImpl(this.tree, this.node);
    }

    @Override
    public Element getDocumentElement() {
        if (this.documentElement != null) {
            return this.documentElement;
        }
        NodeList children = this.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node n = children.item(i);
            if (n.getNodeType() != 1) continue;
            this.documentElement = (Element)n;
            break;
        }
        return this.documentElement;
    }

    @Override
    public boolean isDefaultNamespace(String namespaceURI) {
        Element e = this.getDocumentElement();
        return e != null ? e.isDefaultNamespace(namespaceURI) : false;
    }

    @Override
    public String getDocumentURI() {
        return this.tree.getDocumentURI();
    }

    @Override
    public DOMConfiguration getDomConfig() {
        return null;
    }

    @Override
    public Element getElementById(String arg0) {
        return null;
    }

    @Override
    public NodeList getElementsByTagNameNS(String namespaceURI, String name) {
        return this.getElementsByTagNameNSOrNodeName(namespaceURI, name, false);
    }

    @Override
    public NodeList getElementsByTagName(String localName) {
        return this.getElementsByTagNameNSOrNodeName(null, localName, true);
    }

    @Override
    public DOMImplementation getImplementation() {
        return null;
    }

    @Override
    public String getInputEncoding() {
        return null;
    }

    @Override
    public boolean getStrictErrorChecking() {
        return false;
    }

    @Override
    public String getXmlEncoding() {
        return null;
    }

    @Override
    public boolean getXmlStandalone() {
        return true;
    }

    @Override
    public String getXmlVersion() {
        return "1.0";
    }

    @Override
    public Node importNode(Node arg0, boolean arg1) throws DOMException {
        return null;
    }

    @Override
    public String lookupNamespaceURI(String prefix) {
        return this.getDocumentElement().lookupNamespaceURI(prefix);
    }

    @Override
    public String lookupPrefix(String namespaceURI) {
        return this.getDocumentElement().lookupPrefix(namespaceURI);
    }

    @Override
    public void normalizeDocument() {
        throw new DOMException(7, null);
    }

    @Override
    public Node renameNode(Node arg0, String arg1, String arg2) throws DOMException {
        throw new DOMException(7, null);
    }

    @Override
    public void setDocumentURI(String arg0) {
        throw new DOMException(7, null);
    }

    @Override
    public void setStrictErrorChecking(boolean arg0) {
        throw new DOMException(7, null);
    }

    @Override
    public void setXmlStandalone(boolean arg0) throws DOMException {
        throw new DOMException(7, null);
    }

    @Override
    public void setXmlVersion(String arg0) throws DOMException {
        throw new DOMException(7, null);
    }
}

