/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.contentpump.utilities;

import com.marklogic.contentpump.FileAndDirectoryInputFormat;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.util.ReflectionUtils;

public class FileIterator
implements Iterator<FileSplit> {
    public static final Log LOG = LogFactory.getLog(FileIterator.class);
    protected Iterator<FileSplit> iterator;
    protected List<FileSplit> fileDirSplits;
    protected List<FileSplit> expandedFileSplits;
    protected PathFilter inputFilter;
    protected Configuration conf;

    public FileIterator(Iterator<FileSplit> iterator, TaskAttemptContext context) {
        this.iterator = iterator;
        this.conf = context.getConfiguration();
        this.fileDirSplits = new LinkedList<FileSplit>();
        PathFilter jobFilter = this.getInputPathFilter();
        ArrayList<PathFilter> filters = new ArrayList<PathFilter>();
        filters.add(FileAndDirectoryInputFormat.hiddenFileFilter);
        if (jobFilter != null) {
            filters.add(jobFilter);
        }
        this.inputFilter = new FileAndDirectoryInputFormat.MultiPathFilter(filters);
    }

    public FileIterator(FileSplit inSplit, TaskAttemptContext context) {
        this.conf = context.getConfiguration();
        this.fileDirSplits = new LinkedList<FileSplit>();
        LinkedList<FileSplit> src = new LinkedList<FileSplit>();
        src.add(inSplit);
        this.iterator = src.iterator();
        PathFilter jobFilter = this.getInputPathFilter();
        ArrayList<PathFilter> filters = new ArrayList<PathFilter>();
        filters.add(FileAndDirectoryInputFormat.hiddenFileFilter);
        if (jobFilter != null) {
            filters.add(jobFilter);
        }
        this.inputFilter = new FileAndDirectoryInputFormat.MultiPathFilter(filters);
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext() || !this.fileDirSplits.isEmpty();
    }

    @Override
    public FileSplit next() {
        while (this.iterator.hasNext() || !this.fileDirSplits.isEmpty()) {
            try {
                FileStatus[] children;
                FileStatus status;
                FileSystem fs;
                Path file;
                FileSplit split;
                if (this.iterator.hasNext()) {
                    split = this.iterator.next();
                    file = split.getPath();
                    fs = file.getFileSystem(this.conf);
                    status = fs.getFileStatus(file);
                    if (status.isDirectory()) {
                        for (FileStatus stat : children = fs.listStatus(status.getPath(), this.inputFilter)) {
                            FileSplit child = new FileSplit(stat.getPath(), 0L, stat.getLen(), null);
                            this.fileDirSplits.add(child);
                        }
                        continue;
                    }
                    return split;
                }
                if (this.fileDirSplits.isEmpty()) continue;
                split = this.fileDirSplits.remove(0);
                file = split.getPath();
                fs = file.getFileSystem(this.conf);
                status = fs.getFileStatus(file);
                if (!status.isDirectory()) {
                    return split;
                }
                children = fs.listStatus(status.getPath(), this.inputFilter);
                LinkedList<FileSplit> expdFileSpts = new LinkedList<FileSplit>();
                for (FileStatus stat : children) {
                    FileSplit child = new FileSplit(stat.getPath(), 0L, stat.getLen(), null);
                    expdFileSpts.add(child);
                }
                this.iterator = expdFileSpts.iterator();
            }
            catch (IOException e) {
                LOG.error((Object)"Invalid next file", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    protected PathFilter getInputPathFilter() {
        Class filterClass = this.conf.getClass("mapreduce.input.pathFilter.class", null, PathFilter.class);
        return filterClass != null ? (PathFilter)ReflectionUtils.newInstance((Class)filterClass, (Configuration)this.conf) : null;
    }
}

