/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.contentpump.examples;

import com.marklogic.contentpump.examples.SimpleSequenceFileKey;
import com.marklogic.contentpump.examples.SimpleSequenceFileValue;
import com.marklogic.mapreduce.DocumentURI;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileReader;
import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

public class SimpleSequenceFileCreator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) throws IOException {
        System.out.println("Sequence File Creator");
        String uri = args[0];
        String filePath = args[1];
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.get((URI)URI.create(uri), (Configuration)conf);
        Path path = new Path(uri);
        SequenceFile.Writer writer = null;
        SimpleSequenceFileKey key = new SimpleSequenceFileKey();
        BufferedReader buffer = new BufferedReader(new FileReader(filePath));
        String line = null;
        SimpleSequenceFileValue<Text> value = new SimpleSequenceFileValue<Text>();
        try {
            writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)conf, (Path)path, key.getClass(), value.getClass());
            while ((line = buffer.readLine()) != null) {
                key.setDocumentURI(new DocumentURI(line));
                line = buffer.readLine();
                if (line != null) {
                    value.setValue(new Text(line));
                    writer.append((Writable)key, value);
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeStream(writer);
            buffer.close();
            throw throwable;
        }
        IOUtils.closeStream((Closeable)writer);
        buffer.close();
    }
}

