/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.contentpump;

import com.marklogic.contentpump.ConfigConstants;
import com.marklogic.mapreduce.ContentType;
import com.marklogic.mapreduce.DocumentURI;
import com.marklogic.mapreduce.InternalConstants;
import com.marklogic.mapreduce.MarkLogicConstants;
import com.marklogic.mapreduce.MarkLogicDocument;
import com.marklogic.mapreduce.utilities.URIUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.Charset;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class SingleDocumentWriter
extends RecordWriter<DocumentURI, MarkLogicDocument>
implements MarkLogicConstants,
ConfigConstants,
InternalConstants {
    public static final Log LOG = LogFactory.getLog(SingleDocumentWriter.class);
    Path dir;
    Configuration conf;
    String encoding;

    public SingleDocumentWriter(Path path, Configuration conf) {
        this.dir = path;
        this.conf = conf;
        this.encoding = conf.get("mapreduce.marklogic.output.content.encoding", "UTF-8");
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Default charset: " + Charset.defaultCharset()));
        }
    }

    public void close(TaskAttemptContext arg0) throws IOException, InterruptedException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(DocumentURI uri, MarkLogicDocument content) throws IOException, InterruptedException {
        block24: {
            try (OutputStream os = null;){
                String childPath = URIUtil.getPathFromURI(uri);
                Path path = childPath.charAt(0) == '/' ? new Path(this.dir.toString() + childPath) : new Path(this.dir, childPath);
                FileSystem fs = path.getFileSystem(this.conf);
                if (fs instanceof LocalFileSystem) {
                    File f = new File(path.toUri().getPath());
                    if (!f.exists()) {
                        f.getParentFile().mkdirs();
                        f.createNewFile();
                    }
                    os = new BufferedOutputStream(new FileOutputStream(f, false));
                } else {
                    os = new BufferedOutputStream((OutputStream)fs.create(path, false));
                }
                ContentType type = content.getContentType();
                if (ContentType.BINARY.equals((Object)type)) {
                    if (content.isStreamable()) {
                        try (InputStream is = null;){
                            is = content.getContentAsByteStream();
                            long size = content.getContentSize();
                            long bufSize = Math.min(size, 0x1000000L);
                            byte[] buf = new byte[(int)bufSize];
                            long read = 0L;
                            for (long toRead = size; toRead > 0L; toRead -= read) {
                                read = is.read(buf, 0, (int)bufSize);
                                if (read <= 0L) {
                                    if (size != Integer.MAX_VALUE) {
                                        LOG.error((Object)("Premature EOF: uri=" + uri + ",toRead=" + toRead));
                                    }
                                    break block24;
                                }
                                os.write(buf, 0, (int)read);
                            }
                            break block24;
                        }
                    }
                    os.write(content.getContentAsByteArray());
                    break block24;
                }
                if (ContentType.TEXT.equals((Object)type) || ContentType.XML.equals((Object)type) || ContentType.JSON.equals((Object)type)) {
                    Object t;
                    if (this.encoding.equals("UTF-8")) {
                        t = content.getContentAsText();
                        os.write(t.getBytes(), 0, t.getLength());
                    } else {
                        t = content.getContentAsString();
                        os.write(((String)t).getBytes(this.encoding));
                    }
                    if (LOG.isTraceEnabled()) {
                        t = content.getContentAsText();
                        LOG.trace(t);
                        byte[] bytes = content.getContentAsByteArray();
                        StringBuilder sb = new StringBuilder();
                        for (int i = 0; i < bytes.length; ++i) {
                            sb.append(Byte.toString(bytes[i]));
                            sb.append(" ");
                        }
                        LOG.trace((Object)sb);
                    }
                } else {
                    LOG.error((Object)("Skipping " + uri + ".  Unsupported content type: " + type.name()));
                }
            }
        }
    }

    protected static String getPathFromURI(DocumentURI uri) {
        String uriStr = uri.getUri();
        try {
            URI child = new URI(uriStr);
            String childPath = child.isOpaque() ? child.getSchemeSpecificPart() : child.getPath();
            return childPath;
        }
        catch (Exception ex) {
            LOG.error((Object)("Error parsing URI " + uriStr + "."));
            return uriStr;
        }
    }
}

