/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.contentpump;

import com.marklogic.contentpump.BaseMapper;
import com.marklogic.contentpump.utilities.ReflectionUtil;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.StatusReporter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.util.ReflectionUtils;

public class MultithreadedMapper<K1, V1, K2, V2>
extends Mapper<K1, V1, K2, V2> {
    private static final Log LOG = LogFactory.getLog(MultithreadedMapper.class);
    private Class<? extends BaseMapper<K1, V1, K2, V2>> mapClass;
    private Mapper.Context outer;
    private List<MapRunner> runners;
    private int threadCount = 0;
    private ExecutorService threadPool;

    public int getThreadCount(Mapper.Context context) {
        if (this.threadCount > 0) {
            return this.threadCount;
        }
        return MultithreadedMapper.getNumberOfThreads((JobContext)context);
    }

    public void setThreadCount(int threadCount) {
        this.threadCount = threadCount;
    }

    public ExecutorService getThreadPool() {
        return this.threadPool;
    }

    public void setThreadPool(ExecutorService pool) {
        this.threadPool = pool;
    }

    public static int getNumberOfThreads(JobContext job) {
        return job.getConfiguration().getInt("mapreduce.marklogic.multithreadedmapper.threads", 10);
    }

    public static void setNumberOfThreads(Job job, int threads) {
        job.getConfiguration().setInt("mapreduce.marklogic.multithreadedmapper.threads", threads);
    }

    public static void setNumberOfThreads(Configuration conf, int threads) {
        conf.setInt("mapreduce.marklogic.multithreadedmapper.threads", threads);
    }

    public static <K1, V1, K2, V2> Class<BaseMapper<K1, V1, K2, V2>> getMapperClass(JobContext job) {
        Configuration conf = job.getConfiguration();
        return conf.getClass("mapreduce.marklogic.multithreadedmapper.class", BaseMapper.class);
    }

    public static <K1, V1, K2, V2> void setMapperClass(Configuration conf, Class<? extends BaseMapper<?, ?, ?, ?>> internalMapperClass) {
        if (MultithreadedMapper.class.isAssignableFrom(internalMapperClass)) {
            throw new IllegalArgumentException("Can't have recursive MultithreadedMapper instances.");
        }
        conf.setClass("mapreduce.marklogic.multithreadedmapper.class", internalMapperClass, Mapper.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Mapper.Context context) throws IOException, InterruptedException {
        block16: {
            this.outer = context;
            int numberOfThreads = this.getThreadCount(context);
            this.mapClass = MultithreadedMapper.getMapperClass((JobContext)context);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Running with " + numberOfThreads + " threads"));
            }
            --numberOfThreads;
            InputSplit split = context.getInputSplit();
            try {
                ArrayList taskList = null;
                if (this.threadPool != null) {
                    taskList = new ArrayList();
                    ExecutorService executorService = this.threadPool;
                    synchronized (executorService) {
                        List<Future<Object>> tasks;
                        for (int i = 0; i < numberOfThreads; numberOfThreads -= tasks.size(), ++i) {
                            MapRunner mapRunner = new MapRunner();
                            BaseMapper mapper = mapRunner.getMapper();
                            if (!this.threadPool.isShutdown()) {
                                tasks = mapper.submitTasks(this.threadPool, split);
                                taskList.addAll(tasks);
                            } else {
                                throw new InterruptedException("Thread Pool has been shut down");
                            }
                            Future<?> future = this.threadPool.submit(mapRunner);
                            taskList.add(future);
                        }
                        this.threadPool.notify();
                    }
                    MapRunner r = new MapRunner();
                    r.run();
                    for (Future future : taskList) {
                        future.get();
                    }
                    break block16;
                }
                this.runners = new ArrayList<MapRunner>(numberOfThreads);
                for (int i = 0; i < numberOfThreads; ++i) {
                    MapRunner thread = new MapRunner();
                    thread.start();
                    this.runners.add(i, thread);
                }
                MapRunner r = new MapRunner();
                r.run();
                for (int i = 0; i < numberOfThreads; ++i) {
                    MapRunner mapRunner = this.runners.get(i);
                    mapRunner.join();
                    Throwable th = mapRunner.throwable;
                    if (th == null) continue;
                    if (th instanceof IOException) {
                        throw (IOException)th;
                    }
                    if (th instanceof InterruptedException) {
                        throw (InterruptedException)th;
                    }
                    throw new RuntimeException(th);
                }
            }
            catch (ClassNotFoundException e) {
                LOG.error((Object)"MapRunner class not found", (Throwable)e);
            }
            catch (ExecutionException e) {
                LOG.error((Object)"Error waiting for MapRunner threads to complete", (Throwable)e);
            }
        }
    }

    private class MapRunner
    extends Thread {
        private BaseMapper<K1, V1, K2, V2> mapper;
        private Mapper.Context subcontext;
        private Throwable throwable;
        private RecordWriter<K2, V2> writer;

        MapRunner() throws IOException, InterruptedException, ClassNotFoundException {
            this.mapper = (BaseMapper)((Object)ReflectionUtils.newInstance((Class)MultithreadedMapper.this.mapClass, (Configuration)MultithreadedMapper.this.outer.getConfiguration()));
            OutputFormat outputFormat = (OutputFormat)ReflectionUtils.newInstance((Class)MultithreadedMapper.this.outer.getOutputFormatClass(), (Configuration)MultithreadedMapper.this.outer.getConfiguration());
            try {
                this.writer = outputFormat.getRecordWriter((TaskAttemptContext)MultithreadedMapper.this.outer);
                this.subcontext = ReflectionUtil.createMapperContext(this.mapper, MultithreadedMapper.this.outer.getConfiguration(), MultithreadedMapper.this.outer.getTaskAttemptID(), new SubMapRecordReader(), this.writer, MultithreadedMapper.this.outer.getOutputCommitter(), new SubMapStatusReporter(), MultithreadedMapper.this.outer.getInputSplit());
            }
            catch (Exception e) {
                throw new IOException("Error creating mapper context", e);
            }
        }

        public BaseMapper<K1, V1, K2, V2> getMapper() {
            return this.mapper;
        }

        @Override
        public void run() {
            block5: {
                block4: {
                    try {
                        this.mapper.runThreadSafe(MultithreadedMapper.this.outer, this.subcontext);
                    }
                    catch (Throwable ie) {
                        LOG.error((Object)("Error running task: " + ie.getMessage()));
                        if (!LOG.isDebugEnabled()) break block4;
                        LOG.debug((Object)ie);
                    }
                }
                try {
                    this.writer.close((TaskAttemptContext)this.subcontext);
                }
                catch (Throwable t) {
                    LOG.error((Object)("Error closing writer: " + t.getMessage()));
                    if (!LOG.isDebugEnabled()) break block5;
                    LOG.debug((Object)t);
                }
            }
        }
    }

    private class SubMapStatusReporter
    extends StatusReporter {
        private SubMapStatusReporter() {
        }

        public Counter getCounter(Enum<?> name) {
            return MultithreadedMapper.this.outer.getCounter(name);
        }

        public Counter getCounter(String group, String name) {
            return MultithreadedMapper.this.outer.getCounter(group, name);
        }

        public void progress() {
            MultithreadedMapper.this.outer.progress();
        }

        public void setStatus(String status) {
            MultithreadedMapper.this.outer.setStatus(status);
        }

        public float getProgress() {
            try {
                Method getProgressMethod = MultithreadedMapper.this.outer.getClass().getMethod("getProgress", new Class[0]);
                if (getProgressMethod != null) {
                    return ((Float)getProgressMethod.invoke((Object)MultithreadedMapper.this.outer, new Object[0])).floatValue();
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Error getting progress", (Throwable)e);
            }
            return 0.0f;
        }
    }

    private class SubMapRecordReader
    extends RecordReader<K1, V1> {
        private K1 key;
        private V1 value;

        private SubMapRecordReader() {
        }

        public void close() throws IOException {
        }

        public float getProgress() throws IOException, InterruptedException {
            return 0.0f;
        }

        public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        }

        public boolean nextKeyValue() throws IOException, InterruptedException {
            if (!MultithreadedMapper.this.outer.nextKeyValue()) {
                return false;
            }
            if (MultithreadedMapper.this.outer.getCurrentKey() == null) {
                return true;
            }
            this.key = ReflectionUtils.newInstance(MultithreadedMapper.this.outer.getCurrentKey().getClass(), (Configuration)MultithreadedMapper.this.outer.getConfiguration());
            this.key = ReflectionUtils.copy((Configuration)MultithreadedMapper.this.outer.getConfiguration(), (Object)MultithreadedMapper.this.outer.getCurrentKey(), this.key);
            Object outerVal = MultithreadedMapper.this.outer.getCurrentValue();
            if (outerVal != null) {
                this.value = ReflectionUtils.newInstance(outerVal.getClass(), (Configuration)MultithreadedMapper.this.outer.getConfiguration());
                this.value = ReflectionUtils.copy((Configuration)MultithreadedMapper.this.outer.getConfiguration(), (Object)MultithreadedMapper.this.outer.getCurrentValue(), this.value);
            }
            return true;
        }

        public K1 getCurrentKey() {
            return this.key;
        }

        public V1 getCurrentValue() {
            return this.value;
        }
    }
}

