/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.contentpump;

import com.marklogic.contentpump.ArchiveOutputFormat;
import com.marklogic.contentpump.Command;
import com.marklogic.contentpump.DatabaseContentInputFormat;
import com.marklogic.contentpump.DocumentInputFormat;
import com.marklogic.contentpump.SingleDocumentOutputFormat;
import org.apache.commons.cli.CommandLine;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;

public enum ExportOutputType {
    DOCUMENT{

        @Override
        public Class<? extends Writable> getWritableClass() {
            return BytesWritable.class;
        }

        @Override
        public Class<? extends FileOutputFormat> getOutputFormatClass(CommandLine cmdline) {
            if (Command.isOutputCompressed(cmdline)) {
                return ArchiveOutputFormat.class;
            }
            return SingleDocumentOutputFormat.class;
        }

        @Override
        public Class<? extends InputFormat> getInputFormatClass() {
            return DocumentInputFormat.class;
        }
    }
    ,
    ARCHIVE{

        @Override
        public Class<? extends Writable> getWritableClass() {
            return BytesWritable.class;
        }

        @Override
        public Class<? extends FileOutputFormat> getOutputFormatClass(CommandLine cmdline) {
            return ArchiveOutputFormat.class;
        }

        @Override
        public Class<? extends InputFormat> getInputFormatClass() {
            return DatabaseContentInputFormat.class;
        }
    };


    public abstract Class<? extends Writable> getWritableClass();

    public abstract Class<? extends FileOutputFormat> getOutputFormatClass(CommandLine var1);

    public abstract Class<? extends InputFormat> getInputFormatClass();
}

