/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.contentpump;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.marklogic.contentpump.ContentWithFileNameWritable;
import com.marklogic.contentpump.ImportRecordReader;
import com.marklogic.contentpump.utilities.FileIterator;
import com.marklogic.contentpump.utilities.IdGenerator;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;

public class DelimitedJSONReader<VALUEIN>
extends ImportRecordReader<VALUEIN> {
    public static final Log LOG = LogFactory.getLog(DelimitedJSONReader.class);
    protected InputStreamReader instream;
    protected FSDataInputStream fileIn;
    protected LineNumberReader reader;
    protected ObjectMapper mapper;
    protected String uriName;
    protected long totalBytes = Long.MAX_VALUE;
    protected long bytesRead;
    protected boolean generateId = true;
    protected IdGenerator idGen;
    protected boolean hasNext = true;

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
        if (this.instream != null) {
            this.instream.close();
        }
    }

    @Override
    public float getProgress() throws IOException, InterruptedException {
        return (float)this.bytesRead / (float)this.totalBytes;
    }

    @Override
    public void initialize(InputSplit inSplit, TaskAttemptContext context) throws IOException, InterruptedException {
        this.initConfig(context);
        this.setFile(((FileSplit)inSplit).getPath());
        this.generateId = this.conf.getBoolean("mapreduce.marklogic.input.generateuri", false);
        if (this.generateId) {
            this.idGen = new IdGenerator(this.file.toUri().getPath() + "-" + ((FileSplit)inSplit).getStart());
        } else {
            this.uriName = this.conf.get("mapreduce.marklogic.input.uriid", null);
            this.mapper = new ObjectMapper();
        }
        this.bytesRead = 0L;
        this.totalBytes = inSplit.getLength();
        this.fs = this.file.getFileSystem(context.getConfiguration());
        FileStatus status = this.fs.getFileStatus(this.file);
        if (status.isDirectory()) {
            this.iterator = new FileIterator((FileSplit)inSplit, context);
            inSplit = (InputSplit)this.iterator.next();
        }
        this.initFileStream(inSplit);
    }

    protected boolean findNextFileEntryAndInitReader() throws InterruptedException, IOException {
        if (this.iterator != null && this.iterator.hasNext()) {
            this.close();
            this.initFileStream((InputSplit)this.iterator.next());
            return true;
        }
        this.hasNext = false;
        return false;
    }

    protected void initFileStream(InputSplit inSplit) throws IOException, InterruptedException {
        this.fileIn = this.openFile(inSplit, true);
        if (this.fileIn == null) {
            return;
        }
        this.instream = new InputStreamReader((InputStream)this.fileIn, this.encoding);
        this.reader = new LineNumberReader(this.instream);
    }

    @Override
    public boolean nextKeyValue() throws IOException, InterruptedException {
        if (this.reader == null) {
            this.hasNext = false;
            return false;
        }
        String line = this.reader.readLine();
        int lineNumber = this.reader.getLineNumber();
        if (line == null) {
            if (this.findNextFileEntryAndInitReader()) {
                return this.nextKeyValue();
            }
            this.bytesRead = this.totalBytes;
            return false;
        }
        if (line.trim().equals("")) {
            this.setSkipKey(lineNumber, 0, "empty lines");
            return true;
        }
        if (line.startsWith(" ") || line.startsWith("\t")) {
            this.setSkipKey(lineNumber, 0, "leading space");
            return true;
        }
        if (this.generateId) {
            if (this.setKey(this.idGen.incrementAndGet(), lineNumber, 0, true)) {
                return true;
            }
        } else {
            String uri = null;
            try {
                uri = this.findUriInJSON(line.trim());
                if (uri == null) {
                    this.setSkipKey(lineNumber, 0, "no qualifying URI value found");
                } else {
                    this.setKey(uri, lineNumber, 0, true);
                }
            }
            catch (Exception ex) {
                this.setSkipKey(lineNumber, 0, ex.getMessage());
            }
            if (uri == null) {
                return true;
            }
        }
        if (this.value instanceof Text) {
            ((Text)this.value).set(line);
        } else {
            ((Text)((ContentWithFileNameWritable)this.value).getValue()).set(line);
        }
        this.bytesRead += (long)line.getBytes().length;
        return true;
    }

    protected String findUriInJSON(String line) throws JsonParseException, IOException {
        LinkedList<Object> q = new LinkedList<Object>();
        Object root = this.mapper.readValue(line.getBytes(), Object.class);
        if (root instanceof Map || root instanceof ArrayList) {
            q.add(root);
        } else {
            throw new UnsupportedOperationException("invalid JSON");
        }
        while (!q.isEmpty()) {
            Object current = q.remove();
            if (current instanceof ArrayList) {
                for (Object element : (ArrayList)current) {
                    if (!(element instanceof Map) && !(element instanceof ArrayList)) continue;
                    q.add(element);
                }
                continue;
            }
            Map map = (Map)current;
            if (map.containsKey(this.uriName)) {
                Object uriValue = map.get(this.uriName);
                if (uriValue instanceof Number || uriValue instanceof String) {
                    return uriValue.toString();
                }
                return null;
            }
            for (Map.Entry KVpair : map.entrySet()) {
                Object pairValue = KVpair.getValue();
                if (!(pairValue instanceof Map) && !(pairValue instanceof ArrayList)) continue;
                q.add(pairValue);
            }
        }
        return null;
    }
}

