/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.contentpump;

import com.marklogic.contentpump.DocumentMetadata;
import com.marklogic.mapreduce.ContentType;
import com.marklogic.mapreduce.DatabaseDocument;
import com.marklogic.xcc.ContentCreateOptions;
import com.marklogic.xcc.ContentPermission;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.StringReader;
import org.apache.hadoop.io.WritableUtils;

public class DatabaseDocumentWithMeta
extends DatabaseDocument {
    protected DocumentMetadata meta;

    public DocumentMetadata getMeta() {
        return this.meta;
    }

    public void setMeta(DocumentMetadata meta) {
        this.meta = meta;
    }

    public void updateOptions(ContentCreateOptions options) {
        if (this.meta == null) {
            return;
        }
        options.setQuality(this.meta.quality);
        options.setCollections(this.meta.collectionsList.toArray(new String[this.meta.collectionsList.size()]));
        options.setPermissions(this.meta.permissionsList.toArray(new ContentPermission[this.meta.permissionsList.size()]));
    }

    public String getProperties() {
        return this.meta.getProperties();
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        int len;
        int contentLen = WritableUtils.readVInt((DataInput)in);
        if (0 != contentLen) {
            this.content = new byte[contentLen];
            in.readFully(this.content, 0, contentLen);
            int ordinal = in.readInt();
            this.contentType = ContentType.valueOf(ordinal);
        }
        if (0 != (len = in.readInt())) {
            byte[] xml = new byte[len];
            in.readFully(xml, 0, len);
            StringReader reader = new StringReader(new String(xml));
            this.meta = DocumentMetadata.fromXML(reader);
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        if (null != this.content) {
            WritableUtils.writeVInt((DataOutput)out, (int)this.content.length);
            out.write(this.content, 0, this.content.length);
            out.writeInt(this.contentType.ordinal());
        } else {
            WritableUtils.writeVInt((DataOutput)out, (int)0);
        }
        if (this.meta != null) {
            byte[] xml = this.meta.toXML().getBytes();
            out.writeInt(xml.length);
            out.write(xml);
        } else {
            out.writeInt(0);
        }
    }
}

