/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.contentpump;

import com.marklogic.contentpump.FileAndDirectoryInputFormat;
import com.marklogic.contentpump.GzipDelimitedJSONReader;
import com.marklogic.contentpump.ZipDelimitedJSONReader;
import com.marklogic.mapreduce.CompressionCodec;
import com.marklogic.mapreduce.DocumentURIWithSourceInfo;
import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class CompressedDelimitedJSONInputFormat
extends FileAndDirectoryInputFormat<DocumentURIWithSourceInfo, Text> {
    public RecordReader<DocumentURIWithSourceInfo, Text> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        String codec = context.getConfiguration().get("mapreduce.marklogic.input.compressioncodec", CompressionCodec.ZIP.toString());
        if (codec.equalsIgnoreCase(CompressionCodec.ZIP.toString())) {
            return new ZipDelimitedJSONReader();
        }
        if (codec.equalsIgnoreCase(CompressionCodec.GZIP.toString())) {
            return new GzipDelimitedJSONReader();
        }
        throw new UnsupportedOperationException("Unsupported codec: " + codec);
    }

    @Override
    protected boolean isSplitable(JobContext context, Path filename) {
        return false;
    }
}

