/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.contentpump;

import com.marklogic.contentpump.AggregateXMLReader;
import com.marklogic.contentpump.utilities.FileIterator;
import com.marklogic.contentpump.utilities.IdGenerator;
import com.marklogic.contentpump.utilities.ZipInputStream;
import com.marklogic.mapreduce.CompressionCodec;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;

public class CompressedAggXMLReader<VALUEIN>
extends AggregateXMLReader<VALUEIN> {
    public static final Log LOG = LogFactory.getLog(CompressedAggXMLReader.class);
    private InputStream zipIn;
    private ZipEntry currZipEntry;
    private CompressionCodec codec;

    @Override
    public void close() throws IOException {
        super.close();
        if (this.zipIn != null) {
            if (this.zipIn instanceof ZipInputStream) {
                ((ZipInputStream)this.zipIn).closeStream();
            }
            this.zipIn.close();
        }
    }

    @Override
    public void initialize(InputSplit inSplit, TaskAttemptContext context) throws IOException, InterruptedException {
        this.initConfig(context);
        this.initAggConf(context);
        this.f = XMLInputFactory.newInstance();
        this.setFile(((FileSplit)inSplit).getPath());
        this.fs = this.file.getFileSystem(context.getConfiguration());
        FileStatus status = this.fs.getFileStatus(this.file);
        if (status.isDirectory()) {
            this.iterator = new FileIterator((FileSplit)inSplit, context);
            inSplit = (InputSplit)this.iterator.next();
        }
        this.initStreamReader(inSplit);
    }

    @Override
    protected void initStreamReader(InputSplit inSplit) throws IOException, InterruptedException {
        FSDataInputStream fileIn = this.openFile(inSplit, false);
        if (fileIn == null) {
            return;
        }
        String codecString = this.conf.get("mapreduce.marklogic.input.compressioncodec", CompressionCodec.ZIP.toString());
        if (codecString.equalsIgnoreCase(CompressionCodec.ZIP.toString())) {
            this.zipIn = new ZipInputStream((InputStream)fileIn);
            this.codec = CompressionCodec.ZIP;
            block6: while (true) {
                try {
                    do {
                        this.currZipEntry = ((ZipInputStream)this.zipIn).getNextEntry();
                        if (this.currZipEntry == null) break block6;
                    } while (this.currZipEntry.getSize() == 0L);
                    this.subId = this.currZipEntry.getName();
                }
                catch (IllegalArgumentException e) {
                    LOG.warn((Object)("Skipped a zip entry in : " + this.file.toUri() + ", reason: " + e.getMessage()));
                    continue;
                }
                break;
            }
            if (this.currZipEntry == null) {
                LOG.warn((Object)("No valid entry in zip:" + this.file.toUri()));
                return;
            }
            try {
                this.start = 0L;
                this.end = this.currZipEntry.getSize();
                this.xmlSR = this.f.createXMLStreamReader(this.zipIn, this.encoding);
            }
            catch (XMLStreamException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        } else if (codecString.equalsIgnoreCase(CompressionCodec.GZIP.toString())) {
            this.zipIn = new GZIPInputStream((InputStream)fileIn);
            this.codec = CompressionCodec.GZIP;
            try {
                this.start = 0L;
                this.end = inSplit.getLength();
                this.xmlSR = this.f.createXMLStreamReader(this.zipIn, this.encoding);
            }
            catch (XMLStreamException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        } else {
            throw new UnsupportedOperationException("Unsupported codec: " + codecString);
        }
        if (this.useAutomaticId) {
            this.idGen = new IdGenerator(this.file.toUri().getPath() + "-" + ((FileSplit)inSplit).getStart());
        }
    }

    private boolean nextRecordInAggregate() throws IOException, XMLStreamException, InterruptedException {
        return super.nextKeyValue();
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean nextKeyValue() throws IOException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[DOLOOP]], but top level block is 13[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public CompressedAggXMLReader() {
        this.compressed = true;
    }

    @Override
    public float getProgress() throws IOException, InterruptedException {
        return this.hasNext ? 0.0f : 1.0f;
    }
}

