/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.contentpump;

import com.marklogic.contentpump.ConfigConstants;
import com.marklogic.contentpump.DatabaseDocumentWithMeta;
import com.marklogic.contentpump.DocumentMetadata;
import com.marklogic.contentpump.ExportOutputType;
import com.marklogic.contentpump.OutputArchive;
import com.marklogic.mapreduce.ContentType;
import com.marklogic.mapreduce.DocumentURI;
import com.marklogic.mapreduce.MarkLogicConstants;
import com.marklogic.mapreduce.MarkLogicDocument;
import com.marklogic.mapreduce.utilities.URIUtil;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class ArchiveWriter
extends RecordWriter<DocumentURI, MarkLogicDocument>
implements MarkLogicConstants,
ConfigConstants {
    public static final Log LOG = LogFactory.getLog(ArchiveWriter.class);
    private String dir;
    private TaskAttemptContext context;
    private OutputArchive txtArchive;
    private OutputArchive xmlArchive;
    private OutputArchive jsonArchive;
    private OutputArchive binaryArchive;
    private boolean isExportDoc;
    private String encoding;

    public ArchiveWriter(Path path, TaskAttemptContext context) {
        this.dir = path.toString();
        this.context = context;
        Configuration conf = context.getConfiguration();
        this.encoding = conf.get("mapreduce.marklogic.output.content.encoding", "UTF-8");
        String type = conf.get("mapreduce.marklogic.output.type", "document");
        ExportOutputType outputType = ExportOutputType.valueOf(type.toUpperCase());
        this.isExportDoc = outputType.equals((Object)ExportOutputType.DOCUMENT);
    }

    public void close(TaskAttemptContext arg0) throws IOException, InterruptedException {
        if (this.txtArchive != null) {
            this.txtArchive.close();
        }
        if (this.xmlArchive != null) {
            this.xmlArchive.close();
        }
        if (this.jsonArchive != null) {
            this.jsonArchive.close();
        }
        if (this.binaryArchive != null) {
            this.binaryArchive.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(DocumentURI uri, MarkLogicDocument content) throws IOException, InterruptedException {
        String zipEntryName;
        ContentType type = content.getContentType();
        if (type == null) {
            throw new IOException("null content type: ");
        }
        Configuration conf = this.context.getConfiguration();
        String dst = null;
        String mode = conf.get("mapreduce.marklogic.mode");
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssZ");
        String timestamp = sdf.format(date);
        if (mode.equals("distributed")) {
            dst = this.dir + "/" + this.context.getTaskAttemptID().getTaskID().getId() + "-" + timestamp + "-" + type.toString();
        } else if (mode.equals("local")) {
            dst = this.dir + "/" + timestamp + "-" + type.toString();
        }
        String string = zipEntryName = this.isExportDoc ? URIUtil.getPathFromURI(uri) : uri.getUri();
        if (zipEntryName == null) {
            if (this.isExportDoc) {
                LOG.error((Object)("Error parsing URI, skipping: " + uri));
            } else {
                LOG.error((Object)"Found document with empty URI.");
            }
            return;
        }
        if (ContentType.BINARY.equals((Object)type)) {
            if (this.binaryArchive == null) {
                this.binaryArchive = new OutputArchive(dst, conf);
            }
            if (!this.isExportDoc) {
                this.binaryArchive.write(zipEntryName + DocumentMetadata.EXTENSION, ((DatabaseDocumentWithMeta)content).getMeta().toXML().getBytes(this.encoding), false);
            }
            if (content.isStreamable()) {
                try (InputStream is = null;){
                    long size = content.getContentSize();
                    is = content.getContentAsByteStream();
                    this.binaryArchive.write(zipEntryName, is, size, this.isExportDoc);
                }
            } else {
                this.binaryArchive.write(zipEntryName, content.getContentAsByteArray(), this.isExportDoc);
            }
        } else if (ContentType.TEXT.equals((Object)type)) {
            if (this.txtArchive == null) {
                this.txtArchive = new OutputArchive(dst, conf);
            }
            if (!this.isExportDoc) {
                this.txtArchive.write(zipEntryName + DocumentMetadata.EXTENSION, ((DatabaseDocumentWithMeta)content).getMeta().toXML().getBytes(this.encoding), false);
            }
            String text = content.getContentAsString();
            this.txtArchive.write(zipEntryName, text.getBytes(this.encoding), this.isExportDoc);
        } else if (ContentType.XML.equals((Object)type)) {
            if (this.xmlArchive == null) {
                this.xmlArchive = new OutputArchive(dst, conf);
            }
            if (!this.isExportDoc) {
                if (((DatabaseDocumentWithMeta)content).getMeta().isNakedProps) {
                    this.xmlArchive.write(zipEntryName + DocumentMetadata.NAKED, ((DatabaseDocumentWithMeta)content).getMeta().toXML().getBytes(this.encoding), false);
                } else {
                    this.xmlArchive.write(zipEntryName + DocumentMetadata.EXTENSION, ((DatabaseDocumentWithMeta)content).getMeta().toXML().getBytes(this.encoding), this.isExportDoc);
                    this.xmlArchive.write(zipEntryName, content.getContentAsString().getBytes(this.encoding), this.isExportDoc);
                }
            } else {
                String doc = content.getContentAsString();
                if (doc == null) {
                    LOG.error((Object)("Empty document for " + zipEntryName));
                    return;
                }
                this.xmlArchive.write(zipEntryName, doc.getBytes(this.encoding), this.isExportDoc);
            }
        } else if (ContentType.JSON.equals((Object)type)) {
            if (this.jsonArchive == null) {
                this.jsonArchive = new OutputArchive(dst, conf);
            }
            if (!this.isExportDoc) {
                this.jsonArchive.write(zipEntryName + DocumentMetadata.EXTENSION, ((DatabaseDocumentWithMeta)content).getMeta().toXML().getBytes(this.encoding), this.isExportDoc);
                this.jsonArchive.write(zipEntryName, content.getContentAsString().getBytes(this.encoding), this.isExportDoc);
            } else {
                String doc = content.getContentAsString();
                if (doc == null) {
                    LOG.error((Object)("Empty document for " + zipEntryName));
                    return;
                }
                this.jsonArchive.write(zipEntryName, doc.getBytes(this.encoding), this.isExportDoc);
            }
        } else {
            LOG.error((Object)("Skipping " + uri + ".  Unsupported content type: " + type.name()));
        }
    }
}

