/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mapreduce.utilities;

import com.marklogic.mapreduce.DocumentURI;
import com.marklogic.mapreduce.MarkLogicConstants;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;

public class URIUtil
implements MarkLogicConstants {
    public static final Log LOG = LogFactory.getLog(URIUtil.class);

    public static String applyUriReplace(String uriSource, Configuration conf) {
        if (uriSource == null) {
            return null;
        }
        String[] uriReplace = conf.getStrings("mapreduce.marklogic.output.urireplace");
        if (uriReplace == null) {
            return uriSource;
        }
        for (int i = 0; i < uriReplace.length - 1; i += 2) {
            String replacement = uriReplace[i + 1].trim();
            replacement = replacement.substring(1, replacement.length() - 1);
            uriSource = uriSource.replaceAll(uriReplace[i], replacement);
        }
        return uriSource;
    }

    public static String applyPrefixSuffix(String uriSource, Configuration conf) {
        if (uriSource == null) {
            return null;
        }
        String prefix = conf.get("mapreduce.marklogic.output_uriprefix");
        String suffix = conf.get("mapreduce.marklogic.output_urisuffix");
        if (prefix == null && suffix == null) {
            return uriSource;
        }
        int len = uriSource.length() + (prefix != null ? prefix.length() : 0) + (suffix != null ? suffix.length() : 0);
        StringBuilder uriBuf = new StringBuilder(len);
        if (prefix != null) {
            uriBuf.append(prefix);
        }
        uriBuf.append(uriSource);
        if (suffix != null) {
            uriBuf.append(suffix);
        }
        return uriBuf.toString();
    }

    public static String getPathFromURI(DocumentURI uri) {
        String uriStr = uri.getUri();
        try {
            URI child = new URI(uriStr);
            String childPath = child.isOpaque() ? child.getSchemeSpecificPart() : child.getPath();
            return childPath;
        }
        catch (Exception ex) {
            LOG.warn((Object)("Error parsing URI " + uriStr + "."));
            return uriStr;
        }
    }
}

