/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mapreduce.test;

import com.marklogic.mapreduce.ContentOutputFormat;
import com.marklogic.mapreduce.DocumentURI;
import com.marklogic.mapreduce.test.ZipContentInputFormat;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.map.MultithreadedMapper;
import org.apache.hadoop.util.GenericOptionsParser;

public class MultithreadedZipContentLoader {
    public static void main(String[] args) throws Exception {
        Configuration conf = new Configuration();
        String[] otherArgs = new GenericOptionsParser(conf, args).getRemainingArgs();
        if (otherArgs.length < 2) {
            System.err.println("Usage: MultithreadedZipContentLoader configFile inputDir threadCount");
            System.exit(2);
        }
        Job job = Job.getInstance((Configuration)conf);
        job.setJarByClass(MultithreadedZipContentLoader.class);
        job.setInputFormatClass(ZipContentInputFormat.class);
        job.setMapperClass(MultithreadedMapper.class);
        MultithreadedMapper.setMapperClass((Job)job, ZipContentMapper.class);
        MultithreadedMapper.setNumberOfThreads((Job)job, (int)Integer.parseInt(args[2]));
        job.setMapOutputKeyClass(DocumentURI.class);
        job.setMapOutputValueClass(Text.class);
        job.setOutputFormatClass(ContentOutputFormat.class);
        ZipContentInputFormat.setInputPaths((Job)job, (Path[])new Path[]{new Path(otherArgs[1])});
        conf = job.getConfiguration();
        conf.addResource(otherArgs[0]);
        System.exit(job.waitForCompletion(true) ? 0 : 1);
    }

    public static class ZipContentMapper
    extends Mapper<Text, Text, DocumentURI, Text> {
        private DocumentURI uri = new DocumentURI();

        public void map(Text fileName, Text fileContent, Mapper.Context context) throws IOException, InterruptedException {
            this.uri.setUri(fileName.toString());
            context.write((Object)this.uri, (Object)fileContent);
        }
    }
}

