/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mapreduce.examples;

import com.marklogic.mapreduce.KeyValueOutputFormat;
import com.marklogic.mapreduce.MarkLogicNode;
import com.marklogic.mapreduce.NodeInputFormat;
import com.marklogic.mapreduce.NodePath;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.util.GenericOptionsParser;
import org.w3c.dom.Element;

public class RevisionGrouper {
    public static void main(String[] args) throws Exception {
        Configuration conf = new Configuration();
        if (args.length < 1) {
            System.err.println("Usage: RevisionGrouper configFile");
            System.exit(2);
        }
        String[] otherArgs = new GenericOptionsParser(conf, args).getRemainingArgs();
        Job job = Job.getInstance((Configuration)conf, (String)"revision grouper");
        job.setJarByClass(RevisionGrouper.class);
        job.setInputFormatClass(NodeInputFormat.class);
        job.setMapperClass(RevisionMapper.class);
        job.setOutputFormatClass(KeyValueOutputFormat.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(Text.class);
        conf = job.getConfiguration();
        conf.addResource(otherArgs[0]);
        System.exit(job.waitForCompletion(true) ? 0 : 1);
    }

    public static class RevisionMapper
    extends Mapper<NodePath, MarkLogicNode, Text, Text> {
        private Text uri = new Text();
        private Text year = new Text();

        public void map(NodePath key, MarkLogicNode value, Mapper.Context context) throws IOException, InterruptedException {
            if (value != null && value.get() != null) {
                Element ts = (Element)value.get();
                this.year.set(ts.getTextContent().split("-")[0]);
                this.uri.set(key.getDocumentUri());
                context.write((Object)this.uri, (Object)this.year);
            }
        }
    }
}

