/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mapreduce;

import com.marklogic.mapreduce.DocumentURI;
import com.marklogic.mapreduce.MarkLogicConstants;
import com.marklogic.mapreduce.MarkLogicNode;
import com.marklogic.mapreduce.MarkLogicRecordWriter;
import com.marklogic.mapreduce.PropertyOpType;
import com.marklogic.mapreduce.utilities.InternalUtilities;
import com.marklogic.xcc.AdhocQuery;
import com.marklogic.xcc.Request;
import com.marklogic.xcc.Session;
import com.marklogic.xcc.exceptions.RequestException;
import com.marklogic.xcc.types.ValueType;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;

public class PropertyWriter
extends MarkLogicRecordWriter<DocumentURI, MarkLogicNode>
implements MarkLogicConstants {
    public static final Log LOG = LogFactory.getLog(PropertyWriter.class);
    public static final String DOCURI_VARIABLE_NAME = "uri";
    public static final String NODE_VARIABLE_NAME = "node";
    private String query;

    public PropertyWriter(Configuration conf, String host) {
        super(conf, host);
        String propOpType = conf.get("mapreduce.marklogic.output.property.optype", "SET_PROPERTY");
        PropertyOpType opType = PropertyOpType.valueOf(propOpType);
        this.query = opType.getQuery(conf);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)this.query);
        }
    }

    public void write(DocumentURI uri, MarkLogicNode record) throws IOException, InterruptedException {
        String recordString = record == null ? "()" : record.toString();
        Session session = this.getSession();
        try {
            AdhocQuery request = session.newAdhocQuery(this.query);
            request.setNewStringVariable(DOCURI_VARIABLE_NAME, InternalUtilities.unparse(uri.getUri()));
            request.setNewVariable(NODE_VARIABLE_NAME, (ValueType)ValueType.ELEMENT, (Object)recordString);
            session.submitRequest((Request)request);
            this.commitIfNecessary();
        }
        catch (RequestException e) {
            LOG.error((Object)e);
            LOG.error((Object)this.query);
            throw new IOException(e);
        }
    }
}

