/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mapreduce;

import com.marklogic.mapreduce.utilities.InternalUtilities;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparable;

public class NodePath
implements WritableComparable<NodePath> {
    private String docUri;
    private String path;

    public NodePath() {
    }

    public NodePath(String uri, String path) {
        this.docUri = uri;
        this.path = path;
    }

    public void set(String uri, String path) {
        this.docUri = uri;
        this.path = path;
    }

    public void readFields(DataInput in) throws IOException {
        this.docUri = Text.readString((DataInput)in);
        this.path = Text.readString((DataInput)in);
    }

    public void write(DataOutput out) throws IOException {
        Text.writeString((DataOutput)out, (String)this.docUri);
        Text.writeString((DataOutput)out, (String)this.path);
    }

    public String getDocumentUri() {
        return this.docUri;
    }

    public void setDocumentUri(String docUri) {
        this.docUri = docUri;
    }

    public String getRelativePath() {
        return this.path;
    }

    public void setRelativePath(String path) {
        this.path = path;
    }

    public String getFullPath() {
        StringBuilder buf = new StringBuilder();
        buf.append("fn:doc(\"");
        buf.append(InternalUtilities.unparse(this.docUri));
        buf.append("\")");
        buf.append(this.path);
        return buf.toString();
    }

    public int compareTo(NodePath o) {
        return (this.docUri + this.path).compareTo(o.getDocumentUri() + o.getRelativePath());
    }
}

