/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mapreduce;

import com.marklogic.mapreduce.MarkLogicRecordWriter;
import com.marklogic.mapreduce.utilities.InternalUtilities;
import com.marklogic.xcc.AdhocQuery;
import com.marklogic.xcc.Request;
import com.marklogic.xcc.RequestOptions;
import com.marklogic.xcc.Session;
import com.marklogic.xcc.exceptions.RequestException;
import com.marklogic.xcc.types.ValueType;
import com.marklogic.xcc.types.XName;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;

public class KeyValueWriter<KEYOUT, VALUEOUT>
extends MarkLogicRecordWriter<KEYOUT, VALUEOUT> {
    private ValueType keyType;
    private ValueType valueType;
    private String statement;
    private String queryLanguage;

    public KeyValueWriter(Configuration conf, String host) {
        super(conf, host);
        String keyDataType = conf.get("mapreduce.marklogic.output.keytype", "xs:string");
        this.keyType = ValueType.valueOf((String)keyDataType);
        String valueDataType = conf.get("mapreduce.marklogic.output.valuetype", "xs:string");
        this.valueType = ValueType.valueOf((String)valueDataType);
        this.statement = conf.get("mapreduce.marklogic.output.query");
        this.queryLanguage = conf.get("mapreduce.marklogic.output.querylanguage");
    }

    public void write(KEYOUT key, VALUEOUT value) throws IOException, InterruptedException {
        Session session = this.getSession();
        try {
            AdhocQuery request = session.newAdhocQuery(this.statement);
            if (this.queryLanguage != null) {
                RequestOptions options = new RequestOptions();
                options.setQueryLanguage(this.queryLanguage);
                request.setOptions(options);
            }
            request.setNewVariable(new XName("http://marklogic.com/hadoop", "key"), InternalUtilities.newValue(this.keyType, key));
            request.setNewVariable(new XName("http://marklogic.com/hadoop", "value"), InternalUtilities.newValue(this.valueType, value));
            session.submitRequest((Request)request);
            this.commitIfNecessary();
        }
        catch (RequestException e) {
            LOG.error((Object)e);
            LOG.error((Object)this.statement);
            throw new IOException(e);
        }
    }
}

