/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mapreduce;

import com.marklogic.dom.NodeImpl;
import com.marklogic.dom.TextImpl;
import com.marklogic.mapreduce.ContentType;
import com.marklogic.mapreduce.ForestDocument;
import com.marklogic.mapreduce.MarkLogicNode;
import com.marklogic.tree.ExpandedTree;
import com.marklogic.xcc.Content;
import com.marklogic.xcc.ContentCreateOptions;
import com.marklogic.xcc.ContentFactory;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.Text;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DOMDocument
extends ForestDocument {
    public static final Log LOG = LogFactory.getLog(DOMDocument.class);
    private Document doc;
    private byte rootNodeKind;
    private static TransformerFactory transformerFactory = null;

    private static synchronized TransformerFactory getTransformerFactory() {
        if (transformerFactory == null) {
            transformerFactory = TransformerFactory.newInstance();
        }
        return transformerFactory;
    }

    public DOMDocument() {
    }

    public DOMDocument(ExpandedTree tree) {
        this.doc = (Document)tree.node(0);
        this.rootNodeKind = tree.rootNodeKind();
    }

    public Document getDocument() {
        return this.doc;
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        ExpandedTree tree = new ExpandedTree();
        tree.readFields(in);
        this.doc = (Document)tree.node(0);
        this.rootNodeKind = tree.rootNodeKind();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        ((NodeImpl)((Object)this.doc)).getExpandedTree().write(out);
    }

    static ByteArrayOutputStream serialize(Node node) throws TransformerException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        StreamResult rslt = new StreamResult(bos);
        DOMSource src = new DOMSource(node);
        Transformer transformer = DOMDocument.getTransformerFactory().newTransformer();
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.transform(src, rslt);
        return bos;
    }

    public String toString() {
        TextImpl textNode;
        if (this.rootNodeKind == 2 && (textNode = (TextImpl)this.doc.getFirstChild()) != null) {
            return textNode.getTextContent();
        }
        try {
            ByteArrayOutputStream bos = DOMDocument.serialize(this.doc);
            return bos.toString();
        }
        catch (TransformerException ex) {
            LOG.error((Object)"Error serializing document", (Throwable)ex);
            return null;
        }
    }

    @Override
    public byte[] getContentAsByteArray() {
        TextImpl textNode;
        if (this.rootNodeKind == 2 && (textNode = (TextImpl)this.doc.getFirstChild()) != null) {
            return textNode.getTextContent().getBytes();
        }
        try {
            ByteArrayOutputStream bos = DOMDocument.serialize(this.doc);
            return bos.toByteArray();
        }
        catch (TransformerException ex) {
            LOG.error((Object)"Error serializing document", (Throwable)ex);
            return null;
        }
    }

    @Override
    public MarkLogicNode getContentAsMarkLogicNode() {
        return new MarkLogicNode(this.doc);
    }

    @Override
    public Text getContentAsText() {
        return new Text(this.toString());
    }

    @Override
    public ContentType getContentType() {
        if (this.rootNodeKind == 0 || this.rootNodeKind == 7 || this.rootNodeKind == 6) {
            return ContentType.XML;
        }
        if (this.rootNodeKind == 2) {
            return ContentType.TEXT;
        }
        throw new UnsupportedOperationException("Unknown node kind: " + this.rootNodeKind);
    }

    @Override
    public String getContentAsString() throws UnsupportedEncodingException {
        return this.toString();
    }

    @Override
    public Content createContent(String uri, ContentCreateOptions options, boolean copyCollections, boolean copyMetadata, boolean copyQuality) throws IOException {
        if (copyCollections || copyMetadata || copyQuality) {
            this.setContentOptions(options, copyCollections, copyMetadata, copyQuality);
        }
        return ContentFactory.newContent((String)uri, (Node)this.getContentAsMarkLogicNode().get(), (ContentCreateOptions)options);
    }
}

