/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.contentpump.utilities;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.MapContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.StatusReporter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;

public class ReflectionUtil {
    public static TaskAttemptContext createTaskAttemptContext(Configuration conf, TaskAttemptID taskAttemptId) throws Exception {
        Class<TaskAttemptContext> contextClass = TaskAttemptContext.class;
        int mods = contextClass.getModifiers();
        Class[] types = new Class[]{Configuration.class, TaskAttemptID.class};
        Object[] params = new Object[]{conf, taskAttemptId};
        if (Modifier.isAbstract(mods)) {
            Class<?> contextImplClass = Class.forName("org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl");
            Constructor<?> contextCtr = contextImplClass.getConstructor(types);
            return (TaskAttemptContext)contextCtr.newInstance(params);
        }
        Constructor contextCtr = contextClass.getConstructor(types);
        return (TaskAttemptContext)contextCtr.newInstance(params);
    }

    public static Mapper.Context createMapperContext(Mapper mapper, Configuration conf, TaskAttemptID taskAttemptId, RecordReader reader, RecordWriter writer, OutputCommitter committer, StatusReporter reporter, InputSplit split) throws Exception {
        Class<Mapper.Context> contextClass = Mapper.Context.class;
        int mods = contextClass.getModifiers();
        if (Modifier.isAbstract(mods)) {
            Class[] types = new Class[]{Configuration.class, TaskAttemptID.class, RecordReader.class, RecordWriter.class, OutputCommitter.class, StatusReporter.class, InputSplit.class};
            Object[] params = new Object[]{conf, taskAttemptId, reader, writer, committer, reporter, split};
            Class<?> contextImplClass = Class.forName("org.apache.hadoop.mapreduce.task.MapContextImpl");
            Constructor<?> contextImplCtr = contextImplClass.getConstructor(types);
            Object mapContextImpl = contextImplCtr.newInstance(params);
            Class<?> mapperClass = Class.forName("org.apache.hadoop.mapreduce.lib.map.WrappedMapper");
            Object wrappedMapper = mapperClass.newInstance();
            Class[] contextTypes = new Class[]{MapContext.class};
            Method getMapContext = mapperClass.getMethod("getMapContext", contextTypes);
            Object[] contextParams = new Object[]{mapContextImpl};
            return (Mapper.Context)getMapContext.invoke(wrappedMapper, contextParams);
        }
        Class[] types = new Class[]{Mapper.class, Configuration.class, TaskAttemptID.class, RecordReader.class, RecordWriter.class, OutputCommitter.class, StatusReporter.class, InputSplit.class};
        Object[] params = new Object[]{mapper, conf, taskAttemptId, reader, writer, committer, reporter, split};
        Constructor<?>[] contextCtr = contextClass.getConstructors();
        return (Mapper.Context)contextCtr[0].newInstance(params);
    }
}

