/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.contentpump;

import com.marklogic.contentpump.CompressedRDFReader;
import com.marklogic.contentpump.RDFInputFormat;
import com.marklogic.mapreduce.DocumentURIWithSourceInfo;
import com.marklogic.mapreduce.LinkedMapWritable;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class CompressedRDFInputFormat
extends RDFInputFormat {
    public static final Log LOG = LogFactory.getLog(CompressedRDFInputFormat.class);

    @Override
    public RecordReader<DocumentURIWithSourceInfo, Text> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        String version = null;
        LinkedMapWritable roleMap = null;
        try {
            version = this.getServerVersion(context);
            roleMap = this.getRoleMap(context);
        }
        catch (IOException e) {
            throw new IOException("Error creating CompressedRecordReader:" + e.getMessage());
        }
        return new CompressedRDFReader<Text>(version, roleMap);
    }

    @Override
    protected boolean isSplitable(JobContext context, Path filename) {
        return false;
    }
}

