/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.contentpump;

import com.marklogic.contentpump.CompressedDocumentReader;
import com.marklogic.contentpump.CompressedStreamingReader;
import com.marklogic.contentpump.FileAndDirectoryInputFormat;
import com.marklogic.mapreduce.DocumentURIWithSourceInfo;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class CompressedDocumentInputFormat<VALUE>
extends FileAndDirectoryInputFormat<DocumentURIWithSourceInfo, VALUE> {
    public static final Log LOG = LogFactory.getLog(CompressedDocumentReader.class);

    public RecordReader<DocumentURIWithSourceInfo, VALUE> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        Configuration conf = context.getConfiguration();
        boolean streaming = conf.getBoolean("mapreduce.marklogic.output.content.streaming", false);
        if (streaming) {
            return new CompressedStreamingReader();
        }
        return new CompressedDocumentReader();
    }

    @Override
    protected boolean isSplitable(JobContext context, Path filename) {
        return false;
    }
}

