/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.contentpump;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;

public class CombineDocumentSplit
extends InputSplit
implements Writable {
    private List<FileSplit> splits;
    private long length;
    private Set<String> locations;

    public CombineDocumentSplit() {
        this.splits = new ArrayList<FileSplit>();
        this.locations = new HashSet<String>();
    }

    public CombineDocumentSplit(List<FileSplit> splits) throws IOException, InterruptedException {
        this.splits = splits;
        this.locations = new HashSet<String>();
        for (InputSplit inputSplit : splits) {
            this.length += inputSplit.getLength();
            for (String loc : inputSplit.getLocations()) {
                if (this.locations.contains(loc)) continue;
                this.locations.add(loc);
            }
        }
    }

    public List<FileSplit> getSplits() {
        return this.splits;
    }

    public void setSplits(List<FileSplit> splits) {
        this.splits = splits;
    }

    public void addSplit(FileSplit split) throws IOException, InterruptedException {
        this.splits.add(split);
        this.length += split.getLength();
        for (String loc : split.getLocations()) {
            if (this.locations.contains(loc)) continue;
            this.locations.add(loc);
        }
    }

    public long getLength() throws IOException, InterruptedException {
        return this.length;
    }

    public String[] getLocations() throws IOException, InterruptedException {
        if (this.locations.isEmpty()) {
            return new String[0];
        }
        return this.locations.toArray(new String[this.locations.size()]);
    }

    public void readFields(DataInput in) throws IOException {
        int splitSize = in.readInt();
        this.splits = new ArrayList<FileSplit>();
        for (int i = 0; i < splitSize; ++i) {
            Path path = new Path(Text.readString((DataInput)in));
            long start = in.readLong();
            long len = in.readLong();
            FileSplit split = new FileSplit(path, start, len, null);
            this.splits.add(split);
        }
        this.length = in.readLong();
        this.locations = new HashSet<String>();
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.splits.size());
        for (FileSplit split : this.splits) {
            Text.writeString((DataOutput)out, (String)split.getPath().toString());
            out.writeLong(split.getStart());
            out.writeLong(split.getLength());
        }
        out.writeLong(this.length);
    }
}

