/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.contentpump.utilities;

import com.marklogic.contentpump.ColumnDataType;
import com.marklogic.contentpump.utilities.DocBuilder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;

public class JSONDocBuilder
extends DocBuilder {
    public static final Log LOG = LogFactory.getLog(JSONDocBuilder.class);
    protected JsonFactory jsonFactory;
    protected JsonGenerator generator;
    protected ByteArrayOutputStream baos;
    protected Map<String, ColumnDataType> datatypeMap;

    @Override
    public void init(Configuration conf) {
        this.jsonFactory = new JsonFactory();
    }

    @Override
    public void newDoc() throws IOException {
        this.sb = new StringBuilder();
        this.baos = new ByteArrayOutputStream();
        this.generator = this.jsonFactory.createJsonGenerator((OutputStream)this.baos);
        this.generator.writeStartObject();
    }

    @Override
    public void put(String key, String value) throws Exception {
        block3: {
            try {
                Object valueObj = this.datatypeMap.get(key).parse(value);
                this.generator.writeObjectField(key, valueObj);
            }
            catch (ParseException e) {
                throw new ParseException("Value " + value + " is not type " + this.datatypeMap.get(key).name(), 0);
            }
            catch (Exception e) {
                String msg = e.getMessage();
                if (msg.contains("missing value")) break block3;
                throw new Exception(msg);
            }
        }
    }

    @Override
    public void build() throws IOException {
        this.generator.writeEndObject();
        this.generator.close();
        this.sb.append(this.baos.toString());
    }

    @Override
    public void configFields(Configuration conf, String[] fields) throws IllegalArgumentException, IOException {
        if (null == fields) {
            throw new IOException("Fields not defined");
        }
        super.configFields(conf, fields);
        this.datatypeMap = new HashMap<String, ColumnDataType>();
        for (String s : fields) {
            this.datatypeMap.put(s, ColumnDataType.STRING);
        }
        String list = conf.get("mapreduce.marklogic.delimited.datatype");
        if (list == null) {
            return;
        }
        String[] pairs = list.split(",");
        for (int i = 0; i < pairs.length; i += 2) {
            String colName = pairs[i].trim();
            String colDataType = pairs[i + 1].trim();
            if (!this.datatypeMap.containsKey(colName)) {
                throw new IllegalArgumentException("Column name " + colName + " not found.");
            }
            if ("Number".equalsIgnoreCase(colDataType)) {
                this.datatypeMap.put(colName, ColumnDataType.NUMBER);
                continue;
            }
            if ("Boolean".equalsIgnoreCase(colDataType)) {
                this.datatypeMap.put(colName, ColumnDataType.BOOLEAN);
                continue;
            }
            if ("String".equalsIgnoreCase(colDataType)) continue;
            throw new IllegalArgumentException("Unsupported column data type " + colDataType);
        }
    }
}

