/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.contentpump;

import com.marklogic.contentpump.ContentPump;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.IOUtils;

public class Versions {
    public static final Log LOG = LogFactory.getLog(ContentPump.class);
    private Properties info = new Properties();
    private static Versions MLCP_VERSION_INFO = new Versions("mlcp");

    public static String getVersion() {
        return MLCP_VERSION_INFO._getVersion();
    }

    public static String getMinServerVersion() {
        return MLCP_VERSION_INFO._getMinServerVersion();
    }

    public static String getMaxServerVersion() {
        return MLCP_VERSION_INFO._getMaxServerVersion();
    }

    private String _getMinServerVersion() {
        return this.info.getProperty("minServerVersion", "Unknown");
    }

    private String _getMaxServerVersion() {
        return this.info.getProperty("maxServerVersion", "Unknown");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Versions(String component) {
        String versionInfoFile = component + "-version-info.properties";
        InputStream is = null;
        try {
            is = Thread.currentThread().getContextClassLoader().getResourceAsStream(versionInfoFile);
            if (is == null) {
                throw new IOException("Resource not found");
            }
            this.info.load(is);
        }
        catch (IOException ex) {
            try {
                LogFactory.getLog(this.getClass()).warn((Object)("Could not read '" + versionInfoFile + "', " + ex.toString()), (Throwable)ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeStream(is);
                throw throwable;
            }
            IOUtils.closeStream((Closeable)is);
        }
        IOUtils.closeStream((Closeable)is);
    }

    protected String _getVersion() {
        return this.info.getProperty("version", "Unknown");
    }
}

