/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.contentpump;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.marklogic.contentpump.ContentWithFileNameWritable;
import com.marklogic.contentpump.RDFWritable;
import com.marklogic.contentpump.TransformOutputFormat;
import com.marklogic.io.Base64;
import com.marklogic.mapreduce.ContentType;
import com.marklogic.mapreduce.ContentWriter;
import com.marklogic.mapreduce.DocumentURI;
import com.marklogic.mapreduce.MarkLogicCounter;
import com.marklogic.mapreduce.MarkLogicDocument;
import com.marklogic.mapreduce.ZipEntryInputStream;
import com.marklogic.mapreduce.utilities.AssignmentManager;
import com.marklogic.mapreduce.utilities.InternalUtilities;
import com.marklogic.xcc.AdhocQuery;
import com.marklogic.xcc.ContentCapability;
import com.marklogic.xcc.ContentCreateOptions;
import com.marklogic.xcc.ContentPermission;
import com.marklogic.xcc.ContentSource;
import com.marklogic.xcc.DocumentFormat;
import com.marklogic.xcc.DocumentRepairLevel;
import com.marklogic.xcc.Request;
import com.marklogic.xcc.RequestOptions;
import com.marklogic.xcc.ResultSequence;
import com.marklogic.xcc.Session;
import com.marklogic.xcc.ValueFactory;
import com.marklogic.xcc.exceptions.QueryException;
import com.marklogic.xcc.exceptions.RequestServerException;
import com.marklogic.xcc.types.ValueType;
import com.marklogic.xcc.types.XName;
import com.marklogic.xcc.types.XdmValue;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class TransformWriter<VALUEOUT>
extends ContentWriter<VALUEOUT> {
    public static final Log LOG = LogFactory.getLog(TransformWriter.class);
    static final long TRANS_OPT_MIN_VERSION = 9000200L;
    static final long PROPS_MIN_VERSION = 9000400L;
    static final String MAP_ELEM_START_TAG = "<map:map xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:map=\"http://marklogic.com/xdmp/map\">";
    protected String moduleUri;
    protected String functionNs;
    protected String functionName;
    protected String functionParam;
    protected XdmValue transOpt;
    protected ContentType contentType;
    protected AdhocQuery[] queries;
    protected Set<DocumentURI>[] pendingURIs;
    protected XdmValue[][] uris;
    protected XdmValue[][] values;
    protected XdmValue[][] optionsVals;
    protected HashMap<String, String> optionsMap;
    protected XName uriName;
    protected XName contentName;
    protected XName optionsName;
    protected XName transOptName;
    protected String query;

    public TransformWriter(Configuration conf, Map<String, ContentSource> hostSourceMap, boolean fastLoad, AssignmentManager am) {
        super(conf, hostSourceMap, fastLoad, am);
        this.batchSize = this.effectiveVersion >= 8000604L ? this.batchSize : 1;
        this.moduleUri = conf.get("mapreduce.marklogic.transformmodule");
        this.functionNs = conf.get("mapreduce.marklogic.transformnamespace", "");
        this.functionName = conf.get("mapreduce.marklogic.transformfunction", "transform");
        this.functionParam = conf.get("mapreduce.marklogic.transformparam", "");
        String contentTypeStr = conf.get("mapreduce.marklogic.output.content.type", "XML");
        this.contentType = ContentType.valueOf((String)contentTypeStr);
        this.queries = new AdhocQuery[this.sessions.length];
        this.pendingURIs = new HashSet[this.sessions.length];
        for (int i = 0; i < this.sessions.length; ++i) {
            this.pendingURIs[i] = new HashSet<DocumentURI>(this.batchSize);
        }
        if (this.counts == null) {
            this.counts = new int[this.sessions.length];
        }
        boolean hasOpt = this.effectiveVersion >= 9000200L;
        this.uris = new XdmValue[this.counts.length][this.batchSize];
        this.values = new XdmValue[this.counts.length][this.batchSize];
        this.optionsVals = new XdmValue[this.counts.length][this.batchSize];
        this.optionsMap = new HashMap();
        this.uriName = new XName("URI");
        this.contentName = new XName("CONTENT");
        this.optionsName = new XName("INSERT-OPTIONS");
        this.query = TransformWriter.constructQryString(this.moduleUri, this.functionNs, this.functionName, this.functionParam, this.effectiveVersion, hasOpt);
        if (hasOpt) {
            this.transOptName = new XName("TRANSFORM-OPTION");
            this.transOpt = TransformWriter.constructTransformOption(conf, this.functionParam, this.functionNs);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("query:" + this.query));
        }
    }

    protected boolean needCommit() {
        return this.txnSize > 1;
    }

    private static XdmValue constructTransformOption(Configuration conf, String functionParam, String functionNs) {
        HashMap<String, String> transMap = new HashMap<String, String>();
        String modules = conf.get("mapreduce.marklogic.input.modules");
        String modulesRoot = conf.get("mapreduce.marklogic.input.modulesroot");
        if (modules != null) {
            transMap.put("modules", modules);
        }
        if (modulesRoot != null) {
            transMap.put("modules-root", modulesRoot);
        }
        if (!"".equals(functionNs)) {
            transMap.put("transform-namespace", functionNs);
        }
        if (!"".equals(functionParam)) {
            transMap.put("transform-param", functionParam);
        }
        if (transMap.isEmpty()) {
            return ValueFactory.newJSNull();
        }
        ObjectNode node = TransformWriter.mapToNode(transMap);
        return ValueFactory.newValue((ValueType)ValueType.JS_OBJECT, (Object)node);
    }

    private static String constructQryString(String moduleUri, String functionNs, String functionName, String functionParam, long effectiveVersion, boolean hasOpt) {
        StringBuilder q = new StringBuilder();
        q.append("xquery version \"1.0-ml\";\n").append("import module namespace hadoop = \"http://marklogic.com").append("/xdmp/hadoop\" at \"/MarkLogic/hadoop.xqy\";\n").append("declare variable $URI as xs:string* external;\n").append("declare variable $CONTENT as item()* external;\n").append("declare variable $INSERT-OPTIONS as ");
        if (effectiveVersion < 8000604L) {
            q.append("element() external;\nhadoop:transform-and-insert(\"");
        } else {
            q.append("map:map* external;\n");
            if (hasOpt) {
                q.append("declare variable $TRANSFORM-OPTION as map:map? external;\n");
            }
            q.append("hadoop:transform-insert-batch(\"");
        }
        q.append(moduleUri).append("\",\"");
        if (!hasOpt) {
            q.append(functionNs).append("\",\"");
        }
        q.append(functionName).append("\", ");
        if (!hasOpt) {
            q.append("\"").append(functionParam.replace("\"", "\"\"")).append("\", ");
        } else {
            q.append("$TRANSFORM-OPTION, ");
        }
        q.append("$URI, $CONTENT, $INSERT-OPTIONS");
        q.append(")");
        return q.toString();
    }

    public void write(DocumentURI key, VALUEOUT value) throws IOException, InterruptedException {
        int fId = 0;
        String uri = InternalUtilities.getUriWithOutputDir((DocumentURI)key, (String)this.outputDir);
        if (this.fastLoad) {
            if (!this.countBased) {
                this.sfId = fId = this.am.getPlacementForestIndex(key);
            } else {
                if (this.sfId == -1) {
                    this.sfId = this.am.getPlacementForestIndex(key);
                }
                fId = this.sfId;
            }
        }
        int sid = fId;
        this.addValue(uri, value, sid, this.options, null);
        this.pendingURIs[sid].add((DocumentURI)key.clone());
        int n = sid;
        this.counts[n] = this.counts[n] + 1;
        if (this.counts[n] == this.batchSize) {
            if (this.sessions[sid] == null) {
                this.sessions[sid] = this.getSession(sid, false);
                this.queries[sid] = this.getAdhocQuery(sid);
            }
            this.queries[sid].setNewVariables(this.uriName, this.uris[sid]);
            this.queries[sid].setNewVariables(this.contentName, this.values[sid]);
            this.queries[sid].setNewVariables(this.optionsName, this.optionsVals[sid]);
            this.insertBatch(sid, this.uris[sid], this.values[sid], this.optionsVals[sid]);
            int n2 = sid;
            this.stmtCounts[n2] = this.stmtCounts[n2] + 1;
            if (this.countBased) {
                this.sfId = -1;
            }
            if (this.needCommit) {
                this.commitUris[sid].addAll(this.pendingURIs[sid]);
            } else {
                this.succeeded += this.pendingURIs[sid].size();
            }
            this.pendingURIs[sid].clear();
            boolean committed = false;
            if (this.stmtCounts[sid] == this.txnSize && this.needCommit) {
                this.commit(sid);
                this.stmtCounts[sid] = 0;
                committed = true;
            }
            if (!(this.fastLoad || this.needCommit && !committed)) {
                this.hostId = (this.hostId + 1) % this.forestIds.length;
                this.sessions[0] = null;
                this.queries[0] = null;
            }
        }
    }

    private static String getTypeFromMap(String uri) {
        int idx = uri.lastIndexOf(".");
        Text format = null;
        if (idx != -1) {
            String suff = uri.substring(idx + 1, uri.length());
            if (suff.equalsIgnoreCase("xml")) {
                return "xml";
            }
            format = (Text)TransformOutputFormat.mimetypeMap.get((Object)new Text(suff));
        }
        if (format == null) {
            return "binary";
        }
        return format.toString();
    }

    public static ObjectNode mapToNode(HashMap<String, String> optionsMap) {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode node = mapper.createObjectNode();
        for (Map.Entry<String, String> entry : optionsMap.entrySet()) {
            node.put(entry.getKey(), entry.getValue());
        }
        return node;
    }

    public static String mapToElement(HashMap<String, String> map) {
        StringBuilder sb = new StringBuilder();
        sb.append(MAP_ELEM_START_TAG);
        Set<String> keys = map.keySet();
        for (String k : keys) {
            TransformWriter.addKeyValue(sb, k, map.get(k));
        }
        sb.append("</map:map>");
        return sb.toString();
    }

    private static void addKeyValue(StringBuilder sb, String key, String value) {
        sb.append("<map:entry key=\"").append(key).append("\"><map:value xsi:type=\"xs:string\">").append(value).append("</map:value></map:entry>");
    }

    protected void addValue(String uri, VALUEOUT value, int id, ContentCreateOptions options, String properties) throws UnsupportedEncodingException {
        String temporalCollection;
        String lang;
        this.uris[id][this.counts[id]] = ValueFactory.newValue((ValueType)ValueType.XS_STRING, (Object)uri);
        ContentType docContentType = this.contentType;
        if (options.getFormat() != DocumentFormat.NONE) {
            docContentType = ContentType.fromFormat((DocumentFormat)options.getFormat());
        } else if (this.contentType == ContentType.MIXED) {
            docContentType = ContentType.forName((String)TransformWriter.getTypeFromMap(uri));
        }
        switch (docContentType) {
            case BINARY: {
                this.values[id][this.counts[id]] = value instanceof MarkLogicDocument ? ValueFactory.newValue((ValueType)ValueType.XS_BASE64_BINARY, (Object)Base64.encodeBytes((byte[])((MarkLogicDocument)value).getContentAsByteArray())) : ValueFactory.newValue((ValueType)ValueType.XS_BASE64_BINARY, (Object)Base64.encodeBytes((byte[])((BytesWritable)value).getBytes(), (int)0, (int)((BytesWritable)value).getLength()));
                this.optionsMap.put("value-type", ValueType.XS_BASE64_BINARY.toString());
                break;
            }
            case TEXT: {
                String encoding;
                if (value instanceof BytesWritable) {
                    encoding = options.getEncoding();
                    this.values[id][this.counts[id]] = ValueFactory.newValue((ValueType)ValueType.XS_STRING, (Object)new String(((BytesWritable)value).getBytes(), 0, ((BytesWritable)value).getLength(), encoding));
                } else {
                    this.values[id][this.counts[id]] = value instanceof MarkLogicDocument ? ValueFactory.newValue((ValueType)ValueType.XS_STRING, (Object)((MarkLogicDocument)value).getContentAsString()) : ValueFactory.newValue((ValueType)ValueType.XS_STRING, (Object)((Text)value).toString());
                }
                this.optionsMap.put("value-type", ValueType.TEXT.toString());
                break;
            }
            case JSON: 
            case XML: {
                String encoding;
                if (value instanceof BytesWritable) {
                    encoding = options.getEncoding();
                    this.values[id][this.counts[id]] = ValueFactory.newValue((ValueType)ValueType.XS_STRING, (Object)new String(((BytesWritable)value).getBytes(), 0, ((BytesWritable)value).getLength(), encoding));
                } else {
                    this.values[id][this.counts[id]] = value instanceof RDFWritable ? ValueFactory.newValue((ValueType)ValueType.XS_STRING, (Object)((RDFWritable)value).getValue().toString()) : (value instanceof ContentWithFileNameWritable ? ValueFactory.newValue((ValueType)ValueType.XS_STRING, (Object)((ContentWithFileNameWritable)value).getValue().toString()) : (value instanceof MarkLogicDocument ? ValueFactory.newValue((ValueType)ValueType.XS_STRING, (Object)((MarkLogicDocument)value).getContentAsString()) : ValueFactory.newValue((ValueType)ValueType.XS_STRING, (Object)((Text)value).toString())));
                }
                this.optionsMap.put("value-type", ValueType.XS_STRING.toString());
                break;
            }
            case MIXED: 
            case UNKNOWN: {
                throw new RuntimeException("Unexpected:" + docContentType);
            }
            default: {
                throw new UnsupportedOperationException("invalid type:" + docContentType);
            }
        }
        String namespace = options.getNamespace();
        if (namespace != null) {
            this.optionsMap.put("namespace", namespace);
        }
        if ((lang = options.getLanguage()) != null) {
            this.optionsMap.put("language", "default-language=" + lang);
        }
        ContentPermission[] perms = options.getPermissions();
        StringBuilder rolesReadList = new StringBuilder();
        StringBuilder rolesExeList = new StringBuilder();
        StringBuilder rolesUpdateList = new StringBuilder();
        StringBuilder rolesInsertList = new StringBuilder();
        StringBuilder rolesNodeUpdateList = new StringBuilder();
        if (perms != null && perms.length > 0) {
            for (ContentPermission cp : perms) {
                String roleName = cp.getRole();
                if (roleName == null || roleName.isEmpty()) {
                    LOG.error((Object)("Illegal role name: " + roleName));
                    continue;
                }
                ContentCapability cc = cp.getCapability();
                if (cc.equals(ContentCapability.READ)) {
                    if (rolesReadList.length() != 0) {
                        rolesReadList.append(",");
                    }
                    rolesReadList.append(roleName);
                    continue;
                }
                if (cc.equals(ContentCapability.EXECUTE)) {
                    if (rolesExeList.length() != 0) {
                        rolesExeList.append(",");
                    }
                    rolesExeList.append(roleName);
                    continue;
                }
                if (cc.equals(ContentCapability.INSERT)) {
                    if (rolesInsertList.length() != 0) {
                        rolesInsertList.append(",");
                    }
                    rolesInsertList.append(roleName);
                    continue;
                }
                if (cc.equals(ContentCapability.UPDATE)) {
                    if (rolesUpdateList.length() != 0) {
                        rolesUpdateList.append(",");
                    }
                    rolesUpdateList.append(roleName);
                    continue;
                }
                if (!cc.equals(ContentCapability.NODE_UPDATE)) continue;
                if (rolesNodeUpdateList.length() != 0) {
                    rolesNodeUpdateList.append(",");
                }
                rolesNodeUpdateList.append(roleName);
            }
        }
        this.optionsMap.put("roles-read", rolesReadList.toString());
        this.optionsMap.put("roles-execute", rolesExeList.toString());
        this.optionsMap.put("roles-update", rolesUpdateList.toString());
        this.optionsMap.put("roles-insert", rolesInsertList.toString());
        this.optionsMap.put("roles-node-update", rolesNodeUpdateList.toString());
        String[] collections = options.getCollections();
        StringBuilder sb = new StringBuilder();
        if (collections != null || value instanceof ContentWithFileNameWritable) {
            if (collections != null) {
                for (int i = 0; i < collections.length; ++i) {
                    if (i != 0) {
                        sb.append(",");
                    }
                    sb.append(collections[i].trim());
                }
            }
            if (value instanceof ContentWithFileNameWritable) {
                if (collections != null) {
                    sb.append(",");
                }
                sb.append(((ContentWithFileNameWritable)value).getFileName());
            }
            this.optionsMap.put("collections", sb.toString());
        }
        this.optionsMap.put("quality", String.valueOf(options.getQuality()));
        DocumentRepairLevel repairLevel = options.getRepairLevel();
        if (!DocumentRepairLevel.DEFAULT.equals(repairLevel)) {
            this.optionsMap.put("xml-repair-level", "repair-" + repairLevel);
        }
        if ((temporalCollection = options.getTemporalCollection()) != null) {
            this.optionsMap.put("temporal-collection", temporalCollection);
        }
        if (properties != null) {
            this.optionsMap.put("properties", properties);
        }
        if (this.effectiveVersion < 8000604L) {
            String optionElem = TransformWriter.mapToElement(this.optionsMap);
            this.optionsVals[id][this.counts[id]] = ValueFactory.newValue((ValueType)ValueType.ELEMENT, (Object)optionElem);
        } else {
            ObjectNode optionsNode = TransformWriter.mapToNode(this.optionsMap);
            this.optionsVals[id][this.counts[id]] = ValueFactory.newValue((ValueType)ValueType.JS_OBJECT, (Object)optionsNode);
        }
        this.optionsMap.clear();
    }

    protected Session getSession(int fId, boolean nextReplica) {
        Session.TransactionMode mode = Session.TransactionMode.AUTO;
        if (this.needCommit) {
            mode = Session.TransactionMode.UPDATE;
        }
        return this.getSession(fId, nextReplica, mode);
    }

    protected AdhocQuery getAdhocQuery(int sid) {
        AdhocQuery q = this.sessions[sid].newAdhocQuery(this.query);
        RequestOptions rOptions = new RequestOptions();
        rOptions.setDefaultXQueryVersion("1.0-ml");
        q.setOptions(rOptions);
        return q;
    }

    protected void insertBatch(int id, XdmValue[] uriList, XdmValue[] valueList, XdmValue[] optionsValList) throws IOException {
        this.retry = 0;
        this.sleepTime = 500;
        while (this.retry < 15) {
            try {
                if (this.retry > 0) {
                    LOG.info((Object)("Retrying insert document " + this.retry));
                }
                if (this.transOpt != null) {
                    this.queries[id].setNewVariable(this.transOptName, this.transOpt);
                }
                ResultSequence rs = this.sessions[id].submitRequest((Request)this.queries[id]);
                while (rs.hasNext()) {
                    String uri = rs.next().asString();
                    LOG.warn((Object)("Failed document " + uri));
                    ++this.failed;
                    this.pendingURIs[id].remove(new DocumentURI(uri));
                    if (!rs.hasNext()) break;
                    String err = rs.next().asString();
                    LOG.warn((Object)err);
                }
                this.counts[id] = 0;
                break;
            }
            catch (Exception e) {
                boolean retryable = true;
                if (e instanceof QueryException) {
                    LOG.error((Object)("QueryException:" + ((QueryException)((Object)e)).getFormatString()));
                    retryable = ((QueryException)((Object)e)).isRetryable();
                } else if (e instanceof RequestServerException) {
                    LOG.error((Object)("RequestServerException:" + e.getMessage()));
                } else {
                    LOG.error((Object)("Exception:" + e.getMessage()));
                }
                this.rollback(id);
                if (retryable && ++this.retry < 15) {
                    try {
                        InternalUtilities.sleep((long)this.sleepTime);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.sleepTime *= 2;
                    if (this.sleepTime > 30000) {
                        this.sleepTime = 30000;
                    }
                    this.sessions[id].close();
                    this.sessions[id] = this.getSession(id, true);
                    this.queries[id] = this.getAdhocQuery(id);
                    this.queries[id].setNewVariables(this.uriName, uriList);
                    this.queries[id].setNewVariables(this.contentName, valueList);
                    this.queries[id].setNewVariables(this.optionsName, optionsValList);
                    continue;
                }
                if (retryable) {
                    LOG.info((Object)"Exceeded max retry");
                }
                for (DocumentURI failedUri : this.pendingURIs[id]) {
                    LOG.warn((Object)("Failed document " + failedUri));
                    ++this.failed;
                }
                this.pendingURIs[id].clear();
                this.counts[id] = 0;
                throw new IOException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(TaskAttemptContext context) throws IOException, InterruptedException {
        Counter failedCounter;
        Counter committedCounter;
        int i;
        for (i = 0; i < this.sessions.length; ++i) {
            block19: {
                if (this.pendingURIs[i].size() > 0) {
                    if (this.sessions[i] == null) {
                        this.sessions[i] = this.getSession(i, false);
                    }
                    if (this.queries[i] == null) {
                        this.queries[i] = this.getAdhocQuery(i);
                    }
                    XdmValue[] urisLeft = new XdmValue[this.counts[i]];
                    System.arraycopy(this.uris[i], 0, urisLeft, 0, this.counts[i]);
                    this.queries[i].setNewVariables(this.uriName, urisLeft);
                    XdmValue[] valuesLeft = new XdmValue[this.counts[i]];
                    System.arraycopy(this.values[i], 0, valuesLeft, 0, this.counts[i]);
                    this.queries[i].setNewVariables(this.contentName, valuesLeft);
                    XdmValue[] optionsLeft = new XdmValue[this.counts[i]];
                    System.arraycopy(this.optionsVals[i], 0, optionsLeft, 0, this.counts[i]);
                    this.queries[i].setNewVariables(this.optionsName, optionsLeft);
                    try {
                        this.insertBatch(i, urisLeft, valuesLeft, optionsLeft);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (!this.needCommit) {
                        this.succeeded += this.pendingURIs[i].size();
                    } else {
                        int n = i;
                        this.stmtCounts[n] = this.stmtCounts[n] + 1;
                        this.commitUris[i].addAll(this.pendingURIs[i]);
                    }
                }
                if (this.stmtCounts[i] <= 0 || !this.needCommit) continue;
                try {
                    this.commit(i);
                }
                catch (Exception e) {
                    LOG.error((Object)("Error committing transaction: " + e.getMessage()));
                    if (!LOG.isDebugEnabled()) break block19;
                    LOG.debug((Object)e);
                }
            }
            this.succeeded += this.commitUris[i].size();
        }
        for (i = 0; i < this.sessions.length; ++i) {
            if (this.sessions[i] == null) continue;
            this.sessions[i].close();
        }
        if (this.is != null) {
            this.is.close();
            if (this.is instanceof ZipEntryInputStream) {
                ((ZipEntryInputStream)this.is).closeZipInputStream();
            }
        }
        Counter e = committedCounter = context.getCounter((Enum)MarkLogicCounter.OUTPUT_RECORDS_COMMITTED);
        synchronized (e) {
            committedCounter.increment((long)this.succeeded);
        }
        Counter counter = failedCounter = context.getCounter((Enum)MarkLogicCounter.OUTPUT_RECORDS_FAILED);
        synchronized (counter) {
            failedCounter.increment((long)this.failed);
        }
    }
}

