/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.contentpump;

import com.marklogic.mapreduce.CustomContent;
import com.marklogic.mapreduce.MarkLogicNode;
import com.marklogic.xcc.Content;
import com.marklogic.xcc.ContentCapability;
import com.marklogic.xcc.ContentCreateOptions;
import com.marklogic.xcc.ContentFactory;
import com.marklogic.xcc.ContentPermission;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;
import org.w3c.dom.Node;

public class RDFWritable<VALUE>
implements CustomContent {
    public static final Log LOG = LogFactory.getLog(RDFWritable.class);
    private VALUE value;
    private String graphUri = null;
    private byte type = 0;
    private ContentPermission[] permissions;

    public void set(String value) {
        this.value = new Text(value);
    }

    public void setGraph(String uri) {
        this.graphUri = uri;
    }

    public void setPermissions(ContentPermission[] permissions) {
        this.permissions = permissions;
    }

    public VALUE getValue() {
        return this.value;
    }

    public Content getContent(Configuration conf, ContentCreateOptions options, String uri) {
        String[] collections = conf.getStrings("mapreduce.marklogic.output.content.collection");
        String outputGraph = conf.get("mapreduce.marklogic.output.rdf.graph");
        String outputOverrideGraph = conf.get("mapreduce.marklogic.output.rdf.overridegraph");
        if (collections != null) {
            ArrayList<String> optionList = new ArrayList<String>();
            if (this.graphUri == null) {
                if (outputGraph != null) {
                    optionList.add(outputGraph.trim());
                } else if (outputOverrideGraph != null) {
                    optionList.add(outputOverrideGraph.trim());
                }
            } else if (outputOverrideGraph != null) {
                optionList.add(outputOverrideGraph);
            } else {
                optionList.add(this.graphUri);
            }
            Collections.addAll(optionList, collections);
            collections = optionList.toArray(new String[0]);
            for (int i = 0; i < collections.length; ++i) {
                collections[i] = collections[i].trim();
            }
            options.setCollections(collections);
        } else {
            if (this.graphUri == null) {
                this.graphUri = outputOverrideGraph != null ? outputOverrideGraph : (outputGraph != null ? outputGraph : "http://marklogic.com/semantics#default-graph");
            }
            String[] col = new String[]{this.graphUri};
            options.setCollections(col);
        }
        options.setGraph(this.graphUri);
        if (this.permissions != null) {
            options.setPermissions(this.permissions);
        }
        Content content = null;
        if (this.value instanceof Text) {
            content = ContentFactory.newContent((String)uri, (String)((Text)this.value).toString(), (ContentCreateOptions)options);
        } else if (this.value instanceof MarkLogicNode) {
            content = ContentFactory.newContent((String)uri, (Node)((MarkLogicNode)this.value).get(), (ContentCreateOptions)options);
        } else if (this.value instanceof BytesWritable) {
            content = ContentFactory.newContent((String)uri, (byte[])((BytesWritable)this.value).getBytes(), (int)0, (int)((BytesWritable)this.value).getLength(), (ContentCreateOptions)options);
        }
        return content;
    }

    public void write(DataOutput out) throws IOException {
        if (this.graphUri == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            Text t = new Text(this.graphUri);
            t.write(out);
        }
        out.writeByte(this.type);
        if (this.value instanceof Text) {
            ((Text)this.value).write(out);
        } else if (this.value instanceof MarkLogicNode) {
            ((MarkLogicNode)this.value).write(out);
        } else if (this.value instanceof BytesWritable) {
            ((BytesWritable)this.value).write(out);
        }
        if (this.permissions == null) {
            out.writeByte(0);
        } else {
            out.writeByte(this.permissions.length);
            for (int i = 0; i < this.permissions.length; ++i) {
                Text role = new Text(this.permissions[i].getRole());
                Text cap = new Text(this.permissions[i].getCapability().toString());
                role.write(out);
                cap.write(out);
            }
        }
    }

    public void readFields(DataInput in) throws IOException {
        byte hasCollection = in.readByte();
        if (hasCollection != 0) {
            Text t = new Text();
            t.readFields(in);
            this.graphUri = t.toString();
        }
        byte valueType = in.readByte();
        switch (valueType) {
            case 0: {
                this.value = new Text();
                ((Text)this.value).readFields(in);
                break;
            }
            case 1: {
                this.value = new MarkLogicNode();
                ((MarkLogicNode)this.value).readFields(in);
                break;
            }
            case 2: {
                this.value = new BytesWritable();
                ((BytesWritable)this.value).readFields(in);
                break;
            }
            default: {
                throw new IOException("incorrect type");
            }
        }
        this.type = valueType;
        int hasPerms = in.readByte();
        if (hasPerms != 0) {
            int length = hasPerms;
            this.permissions = new ContentPermission[length];
            for (int i = 0; i < length; ++i) {
                Text t = new Text();
                t.readFields(in);
                String role = t.toString();
                t.readFields(in);
                String perm = t.toString();
                ContentCapability capability = null;
                if (perm.equalsIgnoreCase(ContentCapability.READ.toString())) {
                    capability = ContentCapability.READ;
                } else if (perm.equalsIgnoreCase(ContentCapability.EXECUTE.toString())) {
                    capability = ContentCapability.EXECUTE;
                } else if (perm.equalsIgnoreCase(ContentCapability.INSERT.toString())) {
                    capability = ContentCapability.INSERT;
                } else if (perm.equalsIgnoreCase(ContentCapability.UPDATE.toString())) {
                    capability = ContentCapability.UPDATE;
                } else if (perm.equalsIgnoreCase(ContentCapability.NODE_UPDATE.toString())) {
                    capability = ContentCapability.NODE_UPDATE;
                } else {
                    LOG.error((Object)("Illegal permission: " + perm));
                }
                this.permissions[i] = new ContentPermission(capability, role);
            }
        }
    }
}

