/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.contentpump;

import com.marklogic.contentpump.ConfigConstants;
import com.marklogic.contentpump.ContentWithFileNameWritable;
import com.marklogic.mapreduce.ContentType;
import com.marklogic.mapreduce.DocumentURIWithSourceInfo;
import com.marklogic.mapreduce.utilities.URIUtil;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.util.ReflectionUtils;

public abstract class ImportRecordReader<VALUEIN>
extends RecordReader<DocumentURIWithSourceInfo, VALUEIN>
implements ConfigConstants {
    public static final Log LOG = LogFactory.getLog(ImportRecordReader.class);
    protected DocumentURIWithSourceInfo key = new DocumentURIWithSourceInfo();
    protected VALUEIN value;
    protected String mode;
    protected boolean streaming = false;
    protected Configuration conf;
    protected String encoding;
    protected Path file;
    protected FileSystem fs;
    protected Iterator<FileSplit> iterator;
    private String srcId = null;
    protected String subId = "";

    protected boolean setKey(String uri, int line, int col, boolean encode) {
        if (this.key == null) {
            this.key = new DocumentURIWithSourceInfo(uri, this.srcId);
        }
        if (uri != null && !uri.isEmpty()) {
            uri = URIUtil.applyUriReplace((String)uri, (Configuration)this.conf);
            this.key.setSkipReason("");
            if (encode) {
                try {
                    URI uriObj = new URI(null, null, null, 0, uri, null, null);
                    uri = uriObj.toString();
                }
                catch (URISyntaxException e) {
                    uri = null;
                    this.key.setSkipReason(e.getMessage());
                }
            }
            uri = URIUtil.applyPrefixSuffix((String)uri, (Configuration)this.conf);
        } else {
            this.key.setSkipReason("empty uri value");
        }
        this.key.setUri(uri);
        this.key.setSrcId(this.srcId);
        this.key.setSubId(this.subId);
        this.key.setColNumber(col);
        this.key.setLineNumber(line);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Set key: " + this.key));
        }
        return this.key.isSkip();
    }

    protected void setSkipKey(int line, int col, String reason) {
        if (this.key == null) {
            this.key = new DocumentURIWithSourceInfo("", this.srcId, this.subId, line, col);
        } else {
            this.key.setUri("");
            this.key.setSrcId(this.srcId);
            this.key.setSubId(this.subId);
            this.key.setColNumber(col);
            this.key.setLineNumber(line);
        }
        this.key.setSkipReason(reason);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Set key: " + this.key));
        }
    }

    public abstract void close() throws IOException;

    public DocumentURIWithSourceInfo getCurrentKey() throws IOException, InterruptedException {
        return this.key;
    }

    public VALUEIN getCurrentValue() throws IOException, InterruptedException {
        return this.value;
    }

    public abstract float getProgress() throws IOException, InterruptedException;

    public abstract void initialize(InputSplit var1, TaskAttemptContext var2) throws IOException, InterruptedException;

    protected void initConfig(TaskAttemptContext context) {
        this.conf = context.getConfiguration();
        String type = this.conf.get("mapreduce.marklogic.output.content.type", "XML");
        if (!this.conf.getBoolean("mapreduce.marklogic.output.content.streaming", false)) {
            ContentType contentType = ContentType.valueOf((String)type);
            Class valueClass = contentType.getWritableClass();
            this.value = ReflectionUtils.newInstance((Class)valueClass, (Configuration)this.conf);
        }
        this.encoding = this.conf.get("mapreduce.marklogic.output.content.encoding", "UTF-8");
    }

    protected void configFileNameAsCollection(Configuration conf, Path file) {
        if (file == null) {
            return;
        }
        if (conf.getBoolean("mapreduce.marklogic.output.filenameascollection", false)) {
            if (this.value instanceof ContentWithFileNameWritable) {
                ((ContentWithFileNameWritable)this.value).setFileName(file.getName());
            } else {
                ContentWithFileNameWritable<VALUEIN> cvalue = new ContentWithFileNameWritable<VALUEIN>(this.value, file.getName());
                this.value = cvalue;
            }
        }
    }

    protected String makeURIFromPath(Path file) {
        return file.toUri().getPath().toString();
    }

    protected String makeURIForZipEntry(Path zipFile, String val) {
        Path path = new Path(zipFile, val);
        return path.toUri().getPath();
    }

    public abstract boolean nextKeyValue() throws IOException, InterruptedException;

    public Path getFile() {
        return this.file;
    }

    public void setFile(Path file) {
        this.file = file;
        this.srcId = file.toString();
    }

    public FSDataInputStream openFile(InputSplit inSplit, boolean configCol) throws IOException {
        while (true) {
            this.setFile(((FileSplit)inSplit).getPath());
            if (configCol) {
                this.configFileNameAsCollection(this.conf, this.file);
            }
            try {
                return this.fs.open(this.file);
            }
            catch (IllegalArgumentException e) {
                LOG.error((Object)("Input file skipped, reason: " + e.getMessage()));
                if (this.iterator != null && this.iterator.hasNext()) {
                    inSplit = (InputSplit)this.iterator.next();
                    continue;
                }
                return null;
            }
            break;
        }
    }
}

