/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.contentpump;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.lib.input.InvalidInputException;
import org.apache.hadoop.mapreduce.security.TokenCache;
import org.apache.hadoop.security.Credentials;

public abstract class FileAndDirectoryInputFormat<K, V>
extends FileInputFormat<K, V> {
    public static final Log LOG = LogFactory.getLog(FileAndDirectoryInputFormat.class);
    protected static int SPLIT_COUNT_LIMIT = 1000000;
    private static final double SPLIT_SLOP = 1.1;
    public static final PathFilter hiddenFileFilter = new PathFilter(){

        public boolean accept(Path p) {
            String name = p.getName();
            return !name.startsWith("_") && !name.startsWith(".");
        }
    };

    protected boolean isSplitable(JobContext context, Path filename) {
        Configuration conf = context.getConfiguration();
        return conf.getBoolean("mapreduce.marklogic.splitinput", false) && !conf.getBoolean("input_compressed", false);
    }

    public List<InputSplit> getSplits(JobContext job) throws IOException {
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>();
        Configuration conf = job.getConfiguration();
        try {
            List<FileStatus> files = this.listStatus(job);
            long minSize = Math.max(this.getFormatMinSplitSize(), FileAndDirectoryInputFormat.getMinSplitSize((JobContext)job));
            long maxSize = FileAndDirectoryInputFormat.getMaxSplitSize((JobContext)job);
            for (FileStatus child : files) {
                Path path = child.getPath();
                FileSystem fs = path.getFileSystem(conf);
                long length = child.getLen();
                BlockLocation[] blkLocations = null;
                if (!child.isDirectory() || !(fs instanceof DistributedFileSystem)) {
                    blkLocations = fs.getFileBlockLocations(child, 0L, length);
                } else if (length != 0L) {
                    throw new IOException("non-zero length directory on HDFS:" + path.toUri().toString());
                }
                if (length != 0L && this.isSplitable(job, path)) {
                    long blockSize = child.getBlockSize();
                    long splitSize = this.computeSplitSize(blockSize, minSize, maxSize);
                    long bytesRemaining = length;
                    while ((double)bytesRemaining / (double)splitSize > 1.1) {
                        int blkIndex = this.getBlockIndex(blkLocations, length - bytesRemaining);
                        splits.add((InputSplit)new FileSplit(path, length - bytesRemaining, splitSize, blkLocations[blkIndex].getHosts()));
                        bytesRemaining -= splitSize;
                    }
                    if (bytesRemaining == 0L) continue;
                    splits.add((InputSplit)new FileSplit(path, length - bytesRemaining, bytesRemaining, blkLocations[blkLocations.length - 1].getHosts()));
                    continue;
                }
                if (length != 0L) {
                    splits.add((InputSplit)new FileSplit(path, 0L, length, blkLocations[0].getHosts()));
                    continue;
                }
                splits.add((InputSplit)new FileSplit(path, 0L, length, new String[0]));
            }
        }
        catch (InvalidInputException ex) {
            String inPath = conf.get("mapreduce.input.fileinputformat.inputdir");
            String pattern = conf.get("mapreduce.marklogic.input.filepattern", ".*");
            throw new IOException("No input files found with the specified input path " + inPath + " and input file pattern " + pattern, ex);
        }
        PathFilter jobFilter = FileAndDirectoryInputFormat.getInputPathFilter((JobContext)job);
        ArrayList<PathFilter> filters = new ArrayList<PathFilter>();
        filters.add(hiddenFileFilter);
        if (jobFilter != null) {
            filters.add(jobFilter);
        }
        MultiPathFilter inputFilter = new MultiPathFilter(filters);
        int count = 0;
        while (count < splits.size() && splits.size() < SPLIT_COUNT_LIMIT) {
            FileSplit split = (FileSplit)splits.get(count);
            Path file = split.getPath();
            FileSystem fs = file.getFileSystem(conf);
            FileStatus status = fs.getFileStatus(file);
            if (status.isDirectory()) {
                FileStatus[] children = fs.listStatus(file, (PathFilter)inputFilter);
                if (children.length + count < SPLIT_COUNT_LIMIT) {
                    splits.remove(count);
                    for (FileStatus stat : children) {
                        FileSplit child = new FileSplit(stat.getPath(), 0L, stat.getLen(), null);
                        splits.add((InputSplit)child);
                    }
                    continue;
                }
                ++count;
                continue;
            }
            ++count;
        }
        return splits;
    }

    protected List<FileStatus> listStatus(JobContext job) throws IOException {
        Path[] dirs = FileAndDirectoryInputFormat.getInputPaths((JobContext)job);
        if (dirs.length == 0) {
            throw new IOException("No input paths specified in job");
        }
        TokenCache.obtainTokensForNamenodes((Credentials)job.getCredentials(), (Path[])dirs, (Configuration)job.getConfiguration());
        boolean recursive = FileAndDirectoryInputFormat.getInputDirRecursive((JobContext)job);
        ArrayList<PathFilter> filters = new ArrayList<PathFilter>();
        filters.add(hiddenFileFilter);
        PathFilter jobFilter = FileAndDirectoryInputFormat.getInputPathFilter((JobContext)job);
        if (jobFilter != null) {
            filters.add(jobFilter);
        }
        MultiPathFilter inputFilter = new MultiPathFilter(filters);
        List<FileStatus> result = this.simpleListStatus(job, dirs, inputFilter, recursive);
        LOG.info((Object)("Total input paths to process : " + result.size()));
        return result;
    }

    private List<FileStatus> simpleListStatus(JobContext job, Path[] dirs, PathFilter inputFilter, boolean recursive) throws IOException {
        ArrayList<FileStatus> result = new ArrayList<FileStatus>();
        ArrayList<IOException> errors = new ArrayList<IOException>();
        Configuration conf = job.getConfiguration();
        for (int i = 0; i < dirs.length; ++i) {
            FileStatus[] matches;
            Path p = dirs[i];
            FileSystem fs = p.getFileSystem(conf);
            try {
                matches = fs.globStatus(p, inputFilter);
            }
            catch (IllegalArgumentException e) {
                errors.add(new IOException(e.getMessage()));
                continue;
            }
            if (matches == null) {
                errors.add(new IOException("Input path does not exist: " + p));
                continue;
            }
            if (matches.length == 0) {
                errors.add(new IOException("Input Pattern " + p + " matches 0 files"));
                continue;
            }
            for (FileStatus globStat : matches) {
                if (globStat.isDirectory()) {
                    FileStatus[] files = fs.listStatus(globStat.getPath(), inputFilter);
                    for (int j = 0; j < files.length; ++j) {
                        if (recursive && files[j].isDirectory()) {
                            this.simpleAddInputPathRecursively(result, fs, files[j].getPath(), inputFilter);
                            continue;
                        }
                        result.add(files[j]);
                    }
                    continue;
                }
                result.add(globStat);
            }
        }
        if (!errors.isEmpty()) {
            throw new InvalidInputException(errors);
        }
        return result;
    }

    protected void simpleAddInputPathRecursively(List<FileStatus> result, FileSystem fs, Path path, PathFilter inputFilter) throws IOException {
        FileStatus[] files = fs.listStatus(path, inputFilter);
        for (int j = 0; j < files.length; ++j) {
            if (files[j].isDirectory()) {
                this.simpleAddInputPathRecursively(result, fs, files[j].getPath(), inputFilter);
                continue;
            }
            result.add(files[j]);
        }
    }

    public static class MultiPathFilter
    implements PathFilter {
        private List<PathFilter> filters;

        public MultiPathFilter(List<PathFilter> filters) {
            this.filters = filters;
        }

        public boolean accept(Path path) {
            for (PathFilter filter : this.filters) {
                if (filter.accept(path)) continue;
                return false;
            }
            return true;
        }
    }
}

